# TODO: enable system libtiff when it will support BigTiff (from 4.0?)
%def_without libtiff
%def_without geotiff
%def_with perl
%def_with mysql
%def_with pg
%def_with sqlite

Summary: The Geospatial Data Abstraction Library (GDAL)
Name: gdal
Version: 3.0.4
Release: alt1.4
Group: Sciences/Geosciences

License: MIT
URL: http://www.gdal.org
Packager: ALT QA Team <qa@packages.altlinux.org>
# ftp://ftp.remotesensing.org/%name/%version/%name-%version.tar.xz
Source: %name-%version.tar

Patch0: %name-1.7.1-alt-swig_python.patch
Patch2: %name-alt-apps_install.patch
Patch3: %name-1.7.1-alt-inst_docs.patch
Patch5: %name-alt-libproj.so_name.patch
Patch6: %name-alt-python3.patch
Patch7: %name-2.2.3-alt-mysql8-transition.patch
Patch8: %name-3.0.4-arch-jpeg2000-issue-vendor.patch

%define libname lib%name

BuildRequires: doxygen gcc-c++ libMySQL-devel libcfitsio-devel libcurl-devel libexpat-devel libgeos-devel libgif-devel libhdf5-devel libjasper-devel libjpeg-devel libnumpy-devel libpng-devel libsqlite3-devel libunixODBC-devel perl-devel postgresql-devel swig

BuildRequires: chrpath libnetcdf-devel
BuildRequires: libproj-devel
BuildRequires: perl-Encode
BuildRequires(pre): rpm-build-python3
BuildRequires: python3-devel libnumpy-py3-devel python3-module-genshi
BuildRequires: python3-module-xlwt
BuildRequires: libxerces-c-devel

%description
The Geospatial Data Abstraction Library (GDAL) is a unifying
C/C++ API for accessing raster geospatial data, and currently
includes formats like GeoTIFF, Erdas Imagine, Arc/Info
Binary, CEOS, DTED, GXF, and SDTS. It is intended to provide
efficient access, suitable for use in viewer applications,
and also attempts to preserve coordinate systems and metadata.
Python, C, and C++ interfaces are available.

%package doc
Summary: Documentation for GDAL/OGR
Group: Documentation
BuildArch: noarch

%description doc
This package contains documentation for the GDAL/OGR library
and utilities.

%package scripts
Summary: Scripts for GDAL
Group: Sciences/Geosciences

%description scripts
This package contains various scripts for GDAL (written in python)

%package -n %libname
Summary: Libraries required for the GDAL library
Group: Sciences/Geosciences

%description -n %libname
Libraries required for the GDAL library

%package -n %libname-devel
Summary: Development files for using the GDAL library
Group: Development/C
Requires: %libname = %version-%release

%description -n lib%name-devel
Development files for using the GDAL library

%package -n python-module-%name
Summary: The Python bindings for the GDAL library
Group: Development/Python
Requires: %libname = %version
Requires: %name
Provides: python-module-osgeo = %version

%description -n python-module-%name
Python module for %name.

%package -n python3-module-%name
Summary: The Python bindings for the GDAL library
Group: Development/Python3
Requires: %libname = %version
Requires: %name
Provides: python3-module-osgeo = %version

%description -n python3-module-%name
Python module for %name.

%if_with perl
%package -n perl-Geo-GDAL
Summary: Perl bindings for the GDAL library
Group: Development/Perl
Requires: %libname = %version
Requires: %name

%description -n perl-Geo-GDAL
Perl modules for GDAL/OGR.
%endif

%prep
%setup
#patch0 -p1
%patch2 -p2
%patch3 -p2
#patch5 -p2
%patch6 -p2
%patch7 -p0
%patch8 -p2

%build
%add_optflags -fno-strict-aliasing -I%_includedir/netcdf
%ifarch %e2k
# lcc 1.23 can't do those __builtin_functions (mcst#3588)
%add_optflags -D__INTEL_COMPILER
%endif
%configure \
        --enable-static=no \
        --disable-rpath \
	--datadir=%_datadir/%name \
	--includedir=%_includedir/%name \
	--with-libz \
	--with-png \
%if_with libtiff
	--with-libtiff=yes \
%else
	--with-libtiff=internal \
%endif
%if_with geotiff
	--with-geotiff=yes \
%else
	--with-geotiff=internal \
%endif
	--with-gif \
	--with-jpeg \
	--with-ogr \
	--with-hdf5=%_libdir/hdf5-seq \
	--with-geos \
	--with-jasper\
	--with-odbc \
	--with-curl \
	%{subst_with mysql} \
	%{subst_with pg} \
	%{subst_with sqlite} \
	%{subst_with python} \
	--with-pythonlib=%python_libdir \
	%{subst_with perl} \
	--without-php \
	--without-ruby \
	--with-xerces \
	--with-xerces-inc=%_includedir/xercesc \
	--with-xerces-lib=%_libdir\
	--without-pcraster        \
	--with-threads \
	--without-netcdf \
%ifnarch x86_64
	--with-avx=no \
	--with-sse=no \
	--with-ssse3=no
%endif
#	--with-grass=%_libdir/grass62 \

%if_with perl
# Hack around the issue: https://trac.osgeo.org/gdal/ticket/3084
pushd swig/perl
%make_build veryclean
%make_build generate
popd
%endif

%make_build LD_RUN_PATH= lib-target
%make_build LD_RUN_PATH=
make docs
make -B man

pushd swig/python
%python3_build_debug
popd

%install
mkdir -p %buildroot%python_sitelibdir
%makeinstall_std PYTHONPATH=$PYTHONPATH:%buildroot%python_sitelibdir INSTALLDIRS=vendor
make DESTDIR=%buildroot install-docs
make DESTDIR=%buildroot install-man
mv %buildroot/usr/man %buildroot/usr/share
install -p -m644 NEWS %buildroot%_docdir/%name
%if_with perl
mkdir -p  %buildroot/%_libdir/perl5/
mv %buildroot/usr/lib/perl5/*-linux-thread-multi*/* %buildroot/%_libdir/perl5/
%endif

for i in %buildroot%_bindir/*
do
	chrpath -d $i ||:
done

pushd swig/python
%python3_install
popd
sed -i 's|__bool__ = __nonzero__||' \
	%buildroot%python3_sitelibdir/osgeo/ogr.py

%files
%_datadir/%name
%_bindir/ogr*
%_bindir/gdal*
%_bindir/testepsg
%_bindir/nearblack
%_bindir/gnmanalyse
%_bindir/gnmmanage
%exclude %_bindir/gdal-config
%exclude %_bindir/*.py
%_man1dir/*

%files doc
%_docdir/%name

%files scripts
%_bindir/*.py

%files -n %libname-devel
%_bindir/gdal-config
%_libdir/*.so
%_includedir/%name
%_pkgconfigdir/*

%files -n %libname
%_libdir/*.so.*

%if_with python
%files -n python-module-%name
%python_sitelibdir/*
%endif

%files -n python3-module-%name
%python3_sitelibdir/*

%if_with perl
%files -n perl-Geo-GDAL
%perl_vendor_archlib/Geo
%perl_vendor_autolib/Geo
#exclude %perl_vendor_archlib/Geo/*.dox
#exclude %perl_vendor_archlib/Geo/GDAL/*.dox
%endif

%changelog
