%def_disable snapshot
%define _libexecdir %_prefix/libexec
%define ver_major 40
%define beta %nil
%define xdg_name org.gnome.Geary
# see meson_options.txt
%define profile release

# Elementary OS-specific
%def_disable contractor
%def_enable valadoc
%def_enable libunwind

Name: geary
Version: %ver_major.0
Release: alt1%beta

Summary: Email client
License: LGPL-2.1-or-later
Group: Networking/Mail
Url: https://wiki.gnome.org/Apps/Geary

%if_disabled snapshot
Source: ftp://ftp.gnome.org/pub/gnome/sources/%name/%ver_major/%name-%version%beta.tar.xz
%else
Source: %name-%version.tar
%endif

%define glib_ver 2.66
%define vala_ver 0.48.11
%define gtk_ver 3.24.23
%define sqlite_ver 3.12.0
%define gcr_ver 3.10.1
%define webkit_ver 2.30
%define gmime_ver 3.2.4
%define peas_ver 1.24
%define icu_ver 60
%define handy_ver 1.2.1

Requires: dconf gnome-keyring gcr

BuildRequires(pre): meson
BuildRequires: vala-tools >= %vala_ver libvala-devel
BuildRequires: desktop-file-utils yelp-tools libappstream-glib-devel
BuildRequires: libgio-devel >= %glib_ver libgtk+3-devel >= %gtk_ver
BuildRequires: libsqlite3-devel >= %sqlite_ver
BuildRequires: libpeas-devel >= %peas_ver
BuildRequires: iso-codes-devel libgmime3.0-devel >= %gmime_ver
BuildRequires: libnotify-devel libcanberra-devel libgee0.8-devel
BuildRequires: libsoup-devel libwebkit2gtk-devel >= %webkit_ver
BuildRequires: libgnome-online-accounts-devel libjson-glib-devel
BuildRequires: libenchant-devel libsecret-devel libxml2-devel
BuildRequires: gobject-introspection-devel libgtk+3-gir-devel
BuildRequires: libsoup-gir-devel libwebkit2gtk-gir-devel libcanberra-vala
BuildRequires: gcr-libs-devel >= %gcr_ver gcr-libs-vala
BuildRequires: libfolks-devel  libfolks-vala libenchant2-devel
BuildRequires: libytnef-devel libdbus-devel libgspell-devel
BuildRequires: pkgconfig(icu-uc) >= %icu_ver
BuildRequires: pkgconfig(libhandy-1) >= %handy_ver
BuildRequires: libgsound-devel libstemmer-devel
%{?_enable_libunwind:BuildRequires: libunwind-devel}
%{?_enable_valadoc:BuildRequires: valadoc}

%description
Geary is an email client built for the GNOME desktop environment.  It
allows you to read and send email with a simple, modern interface.

Visit http://www.yorba.org to read about the current state of.
Geary's development.

%prep
%setup -n %name-%version%beta

%build
%add_optflags -I%_includedir/libytnef
%meson  -Dprofile=%profile \
    %{?_enable_contractor:-Dcontractor=true} \
    %{?_disable_libunwind:-Dlibunwind_optional=true}
%nil
%meson_build

%install
%meson_install
%find_lang --with-gnome %name

%files -f %name.lang
%_bindir/%name
%{?_enable_contractor:%_bindir/%name-attach}
%_libdir/%name/
%_datadir/%name/
%_desktopdir/%xdg_name.desktop
%_desktopdir/%name-autostart.desktop
%_datadir/glib-2.0/schemas/%xdg_name.gschema.xml
%_datadir/dbus-1/services/%xdg_name.service
%_iconsdir/*/*/apps/*
%_iconsdir/hicolor/scalable/actions/*.svg
%_datadir/metainfo/%xdg_name.appdata.xml
%{?_enable_contractor:%_datadir/contractor/geary-attach.contract}
%doc AUTHORS NEWS README* THANKS

%changelog
