%def_disable snapshot
%define _libexecdir %_prefix/libexec
%define rdn_name org.geeqie.Geeqie

%def_enable map
%def_enable ffmpegthumbnailer

Name: geeqie
Version: 1.7.2
Release: alt1

Summary: Graphics file browser utility
License: GPL-2.0-or-later
Group: Graphics
Url: https://www.%name.org

%if_disabled snapshot
Source: https://github.com/BestImageViewer/geeqie/archive/v%version/%name-%version.tar.gz
#Source: %url/%name-%version.tar.bz2
%else
Vcs: https://github.com/BestImageViewer/geeqie.git
Source: %name-%version.tar
%endif
# produced by gen_changelog.sh from git tree
Source1: ChangeLog
Source2: ChangeLog.html

Patch: %name-1.5-libdir-fix.patch

Provides: gqview = %version-%release
Obsoletes: gqview < %version

Requires: %_bindir/exiftool %_bindir/exiftran
Requires: %_bindir/convert %_bindir/gphoto2
Requires: %_bindir/zenity lcms2-utils >= 2.12-alt2

BuildRequires: gcc-c++ yelp-tools intltool libappstream-glib-devel
BuildRequires: python3-module-markdown
BuildRequires: libgtk+3-devel libjpeg-devel libtiff-devel libwebp-devel
BuildRequires: libopenjpeg2.0-devel libdjvu-devel liblcms2-devel
BuildRequires: libpoppler-glib-devel libheif-devel
BuildRequires: libraw-devel libgomp-devel
BuildRequires: libexiv2-devel liblirc-devel zlib-devel libarchive-devel
%{?_enable_map:BuildRequires: libgps-devel pkgconfig(clutter-gtk-1.0) libchamplain-gtk3-devel}
%{?_enable_ffmpegthumbnailer:BuildRequires: libffmpegthumbnailer-devel}

%description
Geeqie is a lightweight image viewer. It was forked from GQview. The development
is focused on features for photo collection maintenance: raw format, Exif/IPTC/XMP
metadata and integration with programs like UFraw, ImageMagick, Gimp, gPhoto or
ExifTool.

%prep
%setup
%patch -b .libdir
cp %SOURCE1 %SOURCE2 ./

sed -i 's/\-Werror//' configure.ac

%build
%add_optflags %(getconf LFS_CFLAGS)
%{?_enable_ffmpegthumbnailer:%add_optflags -Wno-error=unused-function}
%autoreconf
%configure --enable-lirc \
	--enable-largefile \
	--with-readmedir=%_datadir/%name \
	--disable-lua \
	%{subst_enable ffmpegthumbnailer}
%make_build

%install
%makeinstall_std
install -pD -m644 %name.png %buildroot%_liconsdir/%name.png

%find_lang %name

%files -f %name.lang
%_bindir/%name
%_datadir/%name/
%_libdir/%name/
%_desktopdir/%name.desktop
%_pixmapsdir/%name.png
%_iconsdir/hicolor/*x*/apps/%name.png
%_man1dir/%name.1.*
%_datadir/metainfo/%rdn_name.appdata.xml
%doc NEWS README.*

%changelog
