%define        pkgname chef-zero

Name:          gem-%pkgname
Version:       15.0.12
Release:       alt1
Summary:       Self-contained, easy-setup, fast-start in-memory Chef server for testing and solo setup purposes
License:       Apache-2.0
Group:         Development/Ruby
Url:           http://www.opscode.com/
Vcs:           https://github.com/chef/chef-zero.git
Packager:      Ruby Maintainers Team <ruby@packages.altlinux.org>
BuildArch:     noarch

Source:        %name-%version.tar
BuildRequires(pre): rpm-build-ruby
BuildRequires: gem(ffi-yajl)
BuildRequires: gem(mixlib-log)
BuildRequires: gem(uuidtools)

%description
Chef Zero is a simple, easy-install, in-memory Chef server that can be useful
for Chef Client testing and chef-solo-like tasks that require a full Chef
Server. It IS intended to be simple, Chef 11+ compliant, easy to run and fast to
start. It is NOT intended to be secure, scalable, performant or persistent. It
does NO input validation, authentication or authorization (it will not throw a
400, 401 or 403). It does not save data, and will start up empty each time you
start it.

Because Chef Zero runs in memory, it's super fast and lightweight. This makes it
perfect for testing against a "real" Chef Server without mocking the entire
Internet.


%package       -n %pkgname
Summary:       Executable for Chef server for testing and solo setup purposes
Summary:       Library files for %gemname gem
Group:         Development/Documentation
BuildArch:     noarch

%description   -n %pkgname
%summary.

%package       doc
Summary:       Documentation files for %gemname gem
Group:         Development/Documentation
BuildArch:     noarch
Obsoletes:     %pkgname-doc
Provides:      %pkgname-doc

%description   doc
Documentation files for %gemname gem.

%description   doc -l ru_RU.UTF8
Файлы сведений для самоцвета %gemname.


%prep
%setup

%build
%ruby_build

%install
%ruby_install

%check
%ruby_test

%files
%ruby_gemlibdir
%ruby_gemspec

%files         -n %pkgname
%_bindir/%pkgname

%files         doc
%ruby_gemdocdir


%changelog
