%define        _unpackaged_files_terminate_build 1
%define        gemname facter

Name:          gem-facter
Version:       4.5.1
Release:       alt1
Summary:       Ruby library for retrieving facts from operating systems
License:       Apache-2.0
Group:         Development/Ruby
Url:           https://tickets.puppetlabs.com/browse/FACT
Vcs:           https://github.com/puppetlabs/facter.git
Packager:      Ruby Maintainers Team <ruby@packages.altlinux.org>
BuildArch:     noarch

Source:        %name-%version.tar
Patch:         ronn.patch
BuildRequires(pre): rpm-build-ruby
%if_with check
BuildRequires: gem(rake) >= 13.0
BuildRequires: gem(rspec) >= 3.0
BuildRequires: gem(rubocop) >= 0.81.0
BuildRequires: gem(rubocop-performance) >= 1.5.2
BuildRequires: gem(rubocop-rspec) >= 1.38
BuildRequires: gem(simplecov) >= 0.17
BuildRequires: gem(sys-filesystem) >= 1.4
BuildRequires: gem(webmock) >= 3.12
BuildRequires: gem(yard) >= 0.9
BuildRequires: gem(octokit) >= 4.18.0
BuildRequires: gem(packaging) >= 0
BuildRequires: gem(ffi) >= 1.15.5
BuildRequires: gem(ronn-ng) >= 0.7
BuildRequires: gem(hocon) >= 1.3
BuildRequires: gem(thor) >= 1.0.1
BuildConflicts: gem(rspec) >= 4
BuildConflicts: gem(rubocop) >= 2
BuildConflicts: gem(rubocop-performance) >= 2
BuildConflicts: gem(rubocop-rspec) >= 3
BuildConflicts: gem(simplecov) >= 1
BuildConflicts: gem(sys-filesystem) >= 2
BuildConflicts: gem(webmock) >= 4
BuildConflicts: gem(yard) >= 1
BuildConflicts: gem(octokit) >= 6
BuildConflicts: gem(ffi) >= 2
BuildConflicts: gem(ronn-ng) >= 1
BuildConflicts: gem(hocon) >= 2
BuildConflicts: gem(thor) >= 2
%endif

%add_findreq_skiplist %ruby_gemslibdir/**/*
%add_findprov_skiplist %ruby_gemslibdir/**/*
%ruby_use_gem_dependency rake >= 13.1.0,rake < 14
%ruby_use_gem_dependency rubocop >= 1.15.0,rubocop < 2
%ruby_use_gem_dependency simplecov >= 0.17,simplecov < 1
%ruby_use_gem_dependency rubocop-rspec >= 2.4.0,rubocop-rspec < 3
%ruby_use_gem_dependency rubocop-performance >= 1.11.3,rubocop-performance < 2
%ruby_use_gem_dependency ffi >= 1.15.5,ffi < 2
%ruby_use_gem_dependency octokit >= 5.6.1,octokit < 6
Requires:      gem(hocon) >= 1.3
Requires:      gem(thor) >= 1.0.1
Requires:      coreutils
Requires:      dmidecode
Requires:      net-tools
Requires:      pciutils
Requires:      bind-utils
Conflicts:     gem(hocon) >= 2
Conflicts:     gem(thor) >= 2
Obsoletes:     ruby-facter
Provides:      ruby-facter
Provides:      gem(facter) = 4.5.1


%description
A cross-platform Ruby library for retrieving facts from operating systems.
Supports multiple resolution mechanisms, any of which can be restricted to
working only on certain operating systems or environments. Facter is especially
useful for retrieving things like operating system names, IP addresses, MAC
addresses, and SSH keys.

It is easy to extend Facter to include your own custom facts or to include
additional mechanisms for retrieving facts.


%package       -n facter
Version:       4.5.1
Release:       alt1
Summary:       Ruby library for retrieving facts from operating systems executable(s)
Summary(ru_RU.UTF-8): Исполнямка для самоцвета facter
Group:         System/Base
BuildArch:     noarch

Requires:      gem(facter) = 4.5.1

%description   -n facter
Ruby library for retrieving facts from operating systems executable(s).

A cross-platform Ruby library for retrieving facts from operating systems.
Supports multiple resolution mechanisms, any of which can be restricted to
working only on certain operating systems or environments. Facter is especially
useful for retrieving things like operating system names, IP addresses, MAC
addresses, and SSH keys.

It is easy to extend Facter to include your own custom facts or to include
additional mechanisms for retrieving facts.

%description   -n facter -l ru_RU.UTF-8
Исполнямка для самоцвета facter.


%package       -n gem-facter-doc
Version:       4.5.1
Release:       alt1
Summary:       Ruby library for retrieving facts from operating systems documentation files
Summary(ru_RU.UTF-8): Файлы сведений для самоцвета facter
Group:         Development/Documentation
BuildArch:     noarch

Requires:      gem(facter) = 4.5.1

%description   -n gem-facter-doc
Ruby library for retrieving facts from operating systems documentation files.

A cross-platform Ruby library for retrieving facts from operating systems.
Supports multiple resolution mechanisms, any of which can be restricted to
working only on certain operating systems or environments. Facter is especially
useful for retrieving things like operating system names, IP addresses, MAC
addresses, and SSH keys.

It is easy to extend Facter to include your own custom facts or to include
additional mechanisms for retrieving facts.

%description   -n gem-facter-doc -l ru_RU.UTF-8
Файлы сведений для самоцвета facter.


%package       -n gem-facter-devel
Version:       4.5.1
Release:       alt1
Summary:       Ruby library for retrieving facts from operating systems development package
Summary(ru_RU.UTF-8): Файлы для разработки самоцвета facter
Group:         Development/Ruby
BuildArch:     noarch

Requires:      gem(facter) = 4.5.1
Requires:      gem(rake) >= 13.0
Requires:      gem(rspec) >= 3.0
Requires:      gem(rubocop) >= 0.81.0
Requires:      gem(rubocop-performance) >= 1.5.2
Requires:      gem(rubocop-rspec) >= 1.38
Requires:      gem(simplecov) >= 0.17
Requires:      gem(sys-filesystem) >= 1.4
Requires:      gem(webmock) >= 3.12
Requires:      gem(yard) >= 0.9
Requires:      gem(octokit) >= 4.18.0
Requires:      gem(packaging) >= 0
Requires:      gem(ffi) >= 1.15.5
Requires:      gem(ronn-ng) >= 0.7
Conflicts:     gem(rspec) >= 4
Conflicts:     gem(rubocop) >= 2
Conflicts:     gem(rubocop-performance) >= 2
Conflicts:     gem(rubocop-rspec) >= 3
Conflicts:     gem(simplecov) >= 1
Conflicts:     gem(sys-filesystem) >= 2
Conflicts:     gem(webmock) >= 4
Conflicts:     gem(yard) >= 1
Conflicts:     gem(octokit) >= 6
Conflicts:     gem(ffi) >= 2
Conflicts:     gem(ronn-ng) >= 1

%description   -n gem-facter-devel
Ruby library for retrieving facts from operating systems development package.

A cross-platform Ruby library for retrieving facts from operating systems.
Supports multiple resolution mechanisms, any of which can be restricted to
working only on certain operating systems or environments. Facter is especially
useful for retrieving things like operating system names, IP addresses, MAC
addresses, and SSH keys.

It is easy to extend Facter to include your own custom facts or to include
additional mechanisms for retrieving facts.

%description   -n gem-facter-devel -l ru_RU.UTF-8
Файлы для разработки самоцвета facter.


%prep
%setup
%autopatch

%build
%ruby_build

%install
%ruby_install

%check
%ruby_test

%files
%ruby_gemspec
%ruby_gemlibdir

%files         -n facter
%_bindir/facter
%_man8dir/facter.*xz

%files         -n gem-facter-doc
%ruby_gemdocdir

%files         -n gem-facter-devel


%changelog
