%define        gemname gettext-setup

Name:          gem-gettext-setup
Version:       1.1.0
Release:       alt1
Summary:       A gem that configures gettext for internationalization
License:       Apache-2.0
Group:         Development/Ruby
Url:           https://github.com/puppetlabs/gettext-setup-gem
Vcs:           https://github.com/puppetlabs/gettext-setup-gem.git
Packager:      Ruby Maintainers Team <ruby@packages.altlinux.org>
BuildArch:     noarch

Source:        %name-%version.tar
Patch:         patch.patch
BuildRequires(pre): rpm-build-ruby
%if_with check
BuildRequires: gem(bundler) >= 0
BuildRequires: gem(rake) >= 0
BuildRequires: gem(rspec) >= 3.1
BuildRequires: gem(rspec-core) >= 3.1
BuildRequires: gem(rspec-expectations) >= 3.1
BuildRequires: gem(rspec-mocks) >= 3.1
BuildRequires: gem(rubocop) >= 0
BuildRequires: gem(simplecov) >= 0
BuildRequires: gem(fast_gettext) >= 2.1
BuildRequires: gem(gettext) >= 3.4
BuildRequires: gem(locale) >= 0
BuildConflicts: gem(rspec) >= 4
BuildConflicts: gem(rspec-core) >= 4
BuildConflicts: gem(rspec-expectations) >= 4
BuildConflicts: gem(rspec-mocks) >= 4
BuildConflicts: gem(fast_gettext) >= 3
BuildConflicts: gem(gettext) >= 4
%endif

%add_findreq_skiplist %ruby_gemslibdir/**/*
%add_findprov_skiplist %ruby_gemslibdir/**/*
Requires:      gem(fast_gettext) >= 2.1
Requires:      gem(gettext) >= 3.4
Requires:      gem(locale) >= 0
Conflicts:     gem(fast_gettext) >= 3
Conflicts:     gem(gettext) >= 4
Obsoletes:     ruby-gettext-setup < %EVR
Provides:      ruby-gettext-setup = %EVR
Provides:      gem(gettext-setup) = 1.1.0


%description
This is a simple gem to set up i18n for Ruby projects (including Sinatra web
apps) using gettext and fast gettext.

This project sets the default locale to English. If the user has set a different
locale in their browser preferences, and we support the user's preferred locale,
strings and data formatting will be customized for that locale.


%package       -n gem-gettext-setup-doc
Version:       1.1.0
Release:       alt1
Summary:       A gem that configures gettext for internationalization documentation files
Summary(ru_RU.UTF-8): Файлы сведений для самоцвета gettext-setup
Group:         Development/Documentation
BuildArch:     noarch

Requires:      gem(gettext-setup) = 1.1.0

%description   -n gem-gettext-setup-doc
A gem that configures gettext for internationalization documentation
files.

This is a simple gem to set up i18n for Ruby projects (including Sinatra web
apps) using gettext and fast gettext.

This project sets the default locale to English. If the user has set a different
locale in their browser preferences, and we support the user's preferred locale,
strings and data formatting will be customized for that locale.

%description   -n gem-gettext-setup-doc -l ru_RU.UTF-8
Файлы сведений для самоцвета gettext-setup.


%package       -n gem-gettext-setup-devel
Version:       1.1.0
Release:       alt1
Summary:       A gem that configures gettext for internationalization development package
Summary(ru_RU.UTF-8): Файлы для разработки самоцвета gettext-setup
Group:         Development/Ruby
BuildArch:     noarch

Requires:      gem(gettext-setup) = 1.1.0
Requires:      gem(bundler) >= 0
Requires:      gem(rake) >= 0
Requires:      gem(rspec) >= 3.1
Requires:      gem(rspec-core) >= 3.1
Requires:      gem(rspec-expectations) >= 3.1
Requires:      gem(rspec-mocks) >= 3.1
Requires:      gem(rubocop) >= 0
Requires:      gem(simplecov) >= 0
Conflicts:     gem(rspec) >= 4
Conflicts:     gem(rspec-core) >= 4
Conflicts:     gem(rspec-expectations) >= 4
Conflicts:     gem(rspec-mocks) >= 4

%description   -n gem-gettext-setup-devel
A gem that configures gettext for internationalization development
package.

This is a simple gem to set up i18n for Ruby projects (including Sinatra web
apps) using gettext and fast gettext.

This project sets the default locale to English. If the user has set a different
locale in their browser preferences, and we support the user's preferred locale,
strings and data formatting will be customized for that locale.

%description   -n gem-gettext-setup-devel -l ru_RU.UTF-8
Файлы для разработки самоцвета gettext-setup.


%prep
%setup
%autopatch

%build
%ruby_build

%install
%ruby_install

%check
%ruby_test

%files
%doc README.md
%ruby_gemspec
%ruby_gemlibdir

%files         -n gem-gettext-setup-doc
%doc README.md
%ruby_gemdocdir

%files         -n gem-gettext-setup-devel
%doc README.md


%changelog
