# vim: set ft=spec: -*- rpm-spec -*-
%define        gemname hpricot

Name:          gem-hpricot
Version:       0.8.6.1
Release:       alt0.1
Summary:       A Fast, Enjoyable HTML Parser for Ruby
License:       MIT
Group:         Development/Ruby
Url:           https://github.com/hpricot/hpricot
Vcs:           https://github.com/hpricot/hpricot.git
Packager:      Ruby Maintainers Team <ruby@packages.altlinux.org>

Source:        %name-%version.tar
BuildRequires(pre): rpm-build-ruby
BuildRequires: ragel6

%add_findreq_skiplist %ruby_gemslibdir/**/*
%add_findprov_skiplist %ruby_gemslibdir/**/*
Obsoletes:     ruby-hpricot
Provides:      ruby-hpricot
Provides:      gem(hpricot) = 0.8.6.1

%ruby_use_gem_version hpricot:0.8.6.1

%description
Hpricot is a fast, flexible HTML parser written in C. It's designed to be very
accommodating (like Tanaka Akira's HTree) and to have a very helpful library
(like some JavaScript libs -- JQuery, Prototype -- give you.) The XPath and CSS
parser, in fact, is based on John Resig's JQuery.


%package       -n gem-hpricot-doc
Version:       0.8.6.1
Release:       alt0.1
Summary:       A Fast, Enjoyable HTML Parser for Ruby documentation files
Summary(ru_RU.UTF-8): Файлы сведений для самоцвета hpricot
Group:         Development/Documentation
BuildArch:     noarch

Requires:      gem(hpricot) = 0.8.6.1

%description   -n gem-hpricot-doc
A Fast, Enjoyable HTML Parser for Ruby documentation files.

Hpricot is a fast, flexible HTML parser written in C. It's designed to be very
accommodating (like Tanaka Akira's HTree) and to have a very helpful library
(like some JavaScript libs -- JQuery, Prototype -- give you.) The XPath and CSS
parser, in fact, is based on John Resig's JQuery.

%description   -n gem-hpricot-doc -l ru_RU.UTF-8
Файлы сведений для самоцвета hpricot.


%package       -n gem-hpricot-devel
Version:       0.8.6.1
Release:       alt0.1
Summary:       A Fast, Enjoyable HTML Parser for Ruby development package
Summary(ru_RU.UTF-8): Файлы для разработки самоцвета hpricot
Group:         Development/Ruby
BuildArch:     noarch

Requires:      gem(hpricot) = 0.8.6.1

%description   -n gem-hpricot-devel
A Fast, Enjoyable HTML Parser for Ruby development package.

Hpricot is a fast, flexible HTML parser written in C. It's designed to be very
accommodating (like Tanaka Akira's HTree) and to have a very helpful library
(like some JavaScript libs -- JQuery, Prototype -- give you.) The XPath and CSS
parser, in fact, is based on John Resig's JQuery.

%description   -n gem-hpricot-devel -l ru_RU.UTF-8
Файлы для разработки самоцвета hpricot.


%prep
%setup

%build
%ruby_build

%install
%ruby_install

%check
%ruby_test

%files
%doc README.md
%ruby_gemspec
%ruby_gemlibdir
%ruby_gemextdir

%files         -n gem-hpricot-doc
%doc README.md
%ruby_gemdocdir

%files         -n gem-hpricot-devel
%doc README.md
%ruby_includedir/*


%changelog
