%define        gemname ohai

Name:          gem-ohai
Version:       18.0.26
Release:       alt1
Summary:       Ohai profiles your system and emits JSON
License:       Apache-2.0
Group:         Development/Ruby
Url:           https://github.com/chef/ohai
Vcs:           https://github.com/chef/ohai.git
Packager:      Ruby Maintainers Team <ruby@packages.altlinux.org>
BuildArch:     noarch

Source:        %name-%version.tar
BuildRequires(pre): rpm-build-ruby
%if_with check
BuildRequires: gem(chefstyle) = 2.2.2
BuildRequires: gem(ipaddr_extensions) >= 0
BuildRequires: gem(rake) >= 10.1.0
BuildRequires: gem(rspec-collection_matchers) >= 1.0
BuildRequires: gem(rspec-core) >= 3.0
BuildRequires: gem(rspec-expectations) >= 3.0
BuildRequires: gem(rspec-mocks) >= 3.0
BuildRequires: gem(rubocop-performance) >= 1.11.3
BuildRequires: gem(rubocop-rspec) >= 0
BuildRequires: gem(pry) >= 0
BuildRequires: gem(pry-byebug) >= 0
BuildRequires: gem(pry-stack_explorer) >= 0
BuildRequires: gem(rb-readline) >= 0
BuildRequires: gem(chef-config) >= 14.12
BuildRequires: gem(chef-utils) >= 16.0
BuildRequires: gem(ffi) >= 1.9
BuildRequires: gem(ffi-yajl) >= 2.2
BuildRequires: gem(ipaddress) >= 0
BuildRequires: gem(mixlib-cli) >= 1.7.0
BuildRequires: gem(mixlib-config) >= 2.0
BuildRequires: gem(mixlib-log) >= 2.0.1
BuildRequires: gem(mixlib-shellout) >= 3.2.5
BuildRequires: gem(plist) >= 3.1
BuildRequires: gem(train-core) >= 0
BuildRequires: gem(wmi-lite) >= 1.0
BuildConflicts: gem(rspec-collection_matchers) >= 2
BuildConflicts: gem(rspec-core) >= 4
BuildConflicts: gem(rspec-expectations) >= 4
BuildConflicts: gem(rspec-mocks) >= 4
BuildConflicts: gem(rubocop-performance) >= 2
BuildConflicts: gem(chef-config) >= 19
BuildConflicts: gem(chef-utils) >= 19
BuildConflicts: gem(ffi) >= 2
BuildConflicts: gem(ffi-yajl) >= 3
BuildConflicts: gem(mixlib-config) >= 4.0
BuildConflicts: gem(mixlib-log) >= 4.0
BuildConflicts: gem(mixlib-shellout) >= 4
BuildConflicts: gem(plist) >= 4
BuildConflicts: gem(wmi-lite) >= 2
%endif

%add_findreq_skiplist %ruby_gemslibdir/**/*
%add_findprov_skiplist %ruby_gemslibdir/**/*
%ruby_use_gem_dependency rubocop-performance >= 1.11.3,rubocop-performance < 2
%ruby_ignore_names rails
Requires:      gem(chef-config) >= 14.12
Requires:      gem(chef-utils) >= 16.0
Requires:      gem(ffi) >= 1.9
Requires:      gem(ffi-yajl) >= 2.2
Requires:      gem(ipaddress) >= 0
Requires:      gem(mixlib-cli) >= 1.7.0
Requires:      gem(mixlib-config) >= 2.0
Requires:      gem(mixlib-log) >= 2.0.1
Requires:      gem(mixlib-shellout) >= 3.2.5
Requires:      gem(plist) >= 3.1
Requires:      gem(train-core) >= 0
Requires:      gem(wmi-lite) >= 1.0
Conflicts:     gem(chef-config) >= 19
Conflicts:     gem(chef-utils) >= 19
Conflicts:     gem(ffi) >= 2
Conflicts:     gem(ffi-yajl) >= 3
Conflicts:     gem(mixlib-config) >= 4.0
Conflicts:     gem(mixlib-log) >= 4.0
Conflicts:     gem(mixlib-shellout) >= 4
Conflicts:     gem(plist) >= 4
Conflicts:     gem(wmi-lite) >= 2
Obsoletes:     ohai < %EVR
Provides:      ohai = %EVR
Provides:      gem(ohai) = 18.0.26


%description
Ohai is a tool that is used to detect attributes on a node, and then provide
these attributes to the chef-client at the start of every chef-client run. Ohai
is required by the chef-client and must be present on a node.


%package       -n ohai
Version:       18.0.26
Release:       alt1
Summary:       Ohai profiles your system and emits JSON executable(s)
Summary(ru_RU.UTF-8): Исполнямка для самоцвета ohai
Group:         Development/Other
BuildArch:     noarch

Requires:      gem(ohai) = 18.0.26

%description   -n ohai
Ohai profiles your system and emits JSON executable(s).

Ohai is a tool that is used to detect attributes on a node, and then provide
these attributes to the chef-client at the start of every chef-client run. Ohai
is required by the chef-client and must be present on a node.

%description   -n ohai -l ru_RU.UTF-8
Исполнямка для самоцвета ohai.


%package       -n gem-ohai-doc
Version:       18.0.26
Release:       alt1
Summary:       Ohai profiles your system and emits JSON documentation files
Summary(ru_RU.UTF-8): Файлы сведений для самоцвета ohai
Group:         Development/Documentation
BuildArch:     noarch

Requires:      gem(ohai) = 18.0.26

%description   -n gem-ohai-doc
Ohai profiles your system and emits JSON documentation files.

Ohai is a tool that is used to detect attributes on a node, and then provide
these attributes to the chef-client at the start of every chef-client run. Ohai
is required by the chef-client and must be present on a node.

%description   -n gem-ohai-doc -l ru_RU.UTF-8
Файлы сведений для самоцвета ohai.


%package       -n gem-ohai-devel
Version:       18.0.26
Release:       alt1
Summary:       Ohai profiles your system and emits JSON development package
Summary(ru_RU.UTF-8): Файлы для разработки самоцвета ohai
Group:         Development/Ruby
BuildArch:     noarch

Requires:      gem(ohai) = 18.0.26
Requires:      gem(chefstyle) = 2.2.2
Requires:      gem(ipaddr_extensions) >= 0
Requires:      gem(rake) >= 10.1.0
Requires:      gem(rspec-collection_matchers) >= 1.0
Requires:      gem(rspec-core) >= 3.0
Requires:      gem(rspec-expectations) >= 3.0
Requires:      gem(rspec-mocks) >= 3.0
Requires:      gem(rubocop-performance) >= 1.11.3
Requires:      gem(rubocop-rspec) >= 0
Requires:      gem(pry) >= 0
Requires:      gem(pry-byebug) >= 0
Requires:      gem(pry-stack_explorer) >= 0
Requires:      gem(rb-readline) >= 0
Conflicts:     gem(rspec-collection_matchers) >= 2
Conflicts:     gem(rspec-core) >= 4
Conflicts:     gem(rspec-expectations) >= 4
Conflicts:     gem(rspec-mocks) >= 4
Conflicts:     gem(rubocop-performance) >= 2

%description   -n gem-ohai-devel
Ohai profiles your system and emits JSON development package.

Ohai is a tool that is used to detect attributes on a node, and then provide
these attributes to the chef-client at the start of every chef-client run. Ohai
is required by the chef-client and must be present on a node.

%description   -n gem-ohai-devel -l ru_RU.UTF-8
Файлы для разработки самоцвета ohai.


%prep
%setup

%build
%ruby_build

%install
%ruby_install

%check
%ruby_test

%files
%ruby_gemspec
%ruby_gemlibdir

%files         -n ohai
%_bindir/ohai

%files         -n gem-ohai-doc
%ruby_gemdocdir

%files         -n gem-ohai-devel


%changelog
