Name: gmsh
Summary: Automatic 3D finite element grid generator
Version: 4.6.0
Release: alt3.1
Group: Sciences/Mathematics
License: GPLv2
URL: https://gmsh.info/

Source: %name-%version.tar

Requires: lib%name = %EVR

BuildPreReq: rpm-macros-cmake rpm-build-python
BuildRequires: cmake gcc-c++ gcc-fortran
BuildRequires: libglvnd-devel libfltk-devel libGLU-devel
BuildRequires: libX11-devel libXft-devel
BuildRequires: libXcursor-devel libXinerama-devel
BuildRequires: libXext-devel libXfixes-devel libXrender-devel
BuildRequires: fontconfig-devel libfreetype-devel
BuildRequires: libjpeg-devel zlib-devel libpng-devel
BuildRequires: libopenblas-devel liblapack-devel opencascade-devel

%description
Gmsh is an automatic 3D finite element grid generator with a built-in CAD engine
and post-processor. Its design goal is to provide a simple meshing tool for
academic problems with parametric input and advanced visualization capabilities.

Gmsh is built around four modules: geometry, mesh, solver and post-processing.
The specification of any input to these modules is done either interactively
using the graphical user interface or in ASCII text files using Gmsh's own
scripting language.


%package -n lib%name
Summary: Shared library for Gmsh
Group: Sciences/Mathematics
%description -n lib%name
This package contains lib%name shared library.


%package -n lib%name-devel
Summary: Shared library for Gmsh
Group: Sciences/Mathematics
%description -n lib%name-devel
This package contains development files for lib%name.


%package -n python-module-%name
Summary: Python interface for lib%name
Group: Sciences/Mathematics
BuildArch: noarch
%description -n python-module-%name
This package contains python interface for lib%name.


%package demos
Summary: Tutorial and demo files for Gmsh
Group: Sciences/Mathematics
BuildArch: noarch
%description demos
This package contains tutorial and demo files for %name.

%prep
%setup

%build
# 1. Dynamic library and private API is needed for compiling getdb
# 2. In Altlinux autodetection does not work correctly for
#    libopenblas + liblapack, BLAS_LAPACK_LIBRARIES should be set.
%cmake_insource\
   -DCMAKE_BUILD_TYPE=Release\
   -DENABLE_BUILD_DYNAMIC=1\
   -DENABLE_PRIVATE_API=1\
   -DBLAS_LAPACK_LIBRARIES="-lopenblas -llapack"

%make_build VERBOSE=1

%install
%makeinstall_std

mkdir -p %buildroot%python_sitelibdir_noarch
mv %buildroot%_libdir/*.py %buildroot%python_sitelibdir_noarch
mv %buildroot%_bindir/*.py %buildroot%python_sitelibdir_noarch

rm -f %buildroot%_libdir/*.jl

%files
%_bindir/%name
%_man1dir/%name.*
%dir %_docdir/%name
%doc %_docdir/%name/*.txt

%files -n lib%name
%_libdir/lib%name.so.*

%files -n lib%name-devel
%_includedir/*
%_libdir/lib%name.so

%files -n python-module-%name
%python_sitelibdir_noarch/*

%files demos
%_docdir/%name/demos
%_docdir/%name/tutorial


%changelog
