%def_disable snapshot
%define xdg_name org.gnome.clocks
%define ver_major 40
%define beta %nil

Name: gnome-clocks
Version: %ver_major.0
Release: alt1%beta

Summary: Clock application designed for GNOME 3
Group: Graphical desktop/GNOME
License: GPL-2.0
Url: https://wiki.gnome.org/Apps/Clocks

%if_disabled snapshot
Source: https://download.gnome.org/sources/%name/%ver_major/%name-%version%beta.tar.xz
%else
Source: %name-%version.tar
%endif

%define glib_ver 2.58
%define gweather_ver 3.27.2
%define geocode_ver 3.18.0
%define geoclue_ver 2.4
%define gtk_ver 3.22.0
%define handy_ver 1.0.0

Requires: geoclue2

BuildRequires(pre): meson
BuildRequires: vala-tools glib2-devel >= %glib_ver
BuildRequires: libappstream-glib-devel desktop-file-utils yelp-tools
BuildRequires: libgtk+3-devel >= %gtk_ver libnotify-devel
BuildRequires: libgsound-devel libgnome-desktop3-devel
BuildRequires: gobject-introspection-devel libgtk+3-gir-devel libgweather-vala
BuildRequires: libgweather-devel >= %gweather_ver libgeocode-glib-devel >= %geocode_ver
BuildRequires: libgeoclue2-devel >= %geoclue_ver
BuildRequires: pkgconfig(libhandy-1) >= %handy_ver

%description
Clock application designed for GNOME 3

%prep
%setup -n %name-%version%beta

%build
%meson
%meson_build

%install
%meson_install
%find_lang --with-gnome %name

%files -f %name.lang
%_bindir/%name
%_datadir/applications/%xdg_name.desktop
%_datadir/glib-2.0/schemas/%xdg_name.gschema.xml
%_datadir/dbus-1/services/%xdg_name.service
%_datadir/gnome-shell/search-providers/%xdg_name.search-provider.ini
%_iconsdir/hicolor/*/*/%{xdg_name}*.*
%_datadir/metainfo/%xdg_name.metainfo.xml
%doc README* NEWS*

%changelog
