%def_disable snapshot

%define ver_major 40
%define beta %nil
%define _libexecdir %_prefix/libexec
%define gst_api_ver 1.0
%define _name org.gnome.Contacts
%def_with cheese

Name: gnome-contacts
Version: %ver_major.0
Release: alt1%beta

Summary: Contacts manager for GNOME
License: GPL-2.0-or-later
Group: Graphical desktop/GNOME
Url: https://wiki.gnome.org/Apps/Contacts

%if_disabled snapshot
Source: ftp://ftp.gnome.org/pub/gnome/sources/%name/%ver_major/%name-%version%beta.tar.xz
%else
Source: %name-%version.tar
%endif

%define glib_ver 2.58
%define gtk_ver 3.24
%define vala_ver 0.17.2
%define tp_glib_ver 0.22.0
%define folks_ver 0.14
%define eds_ver 3.34
%define cheese_ver 3.5.90
%define geocode_ver 3.15.3
%define handy_ver 1.1.0

BuildRequires(pre): meson
BuildRequires: yelp-tools xsltproc docbook-dtds docbook-style-xsl libappstream-glib-devel valadoc
BuildRequires: libgio-devel >= %glib_ver libgtk+3-devel >= %gtk_ver libtelepathy-glib-devel >= %tp_glib_ver
BuildRequires: libfolks-devel >= %folks_ver libvala-devel >= %vala_ver libgnome-desktop3-devel
BuildRequires: libgnome-online-accounts-devel libgee0.8-devel evolution-data-server-devel >= %eds_ver
BuildRequires: libgeocode-glib-devel >= %geocode_ver libchamplain-gtk3-devel libclutter-gtk3-devel
%{?_with_cheese:BuildRequires: gstreamer%gst_api_ver-devel libcheese-devel >= %cheese_ver}
BuildRequires: gobject-introspection-devel vala-tools libgtk+3-gir-devel
BuildRequires: pkgconfig(libhandy-1) >= %handy_ver

# for build from git
BuildRequires: libfolks-vala

%description
%name is a standalone contacts manager for GNOME desktop.

%prep
%setup -n %name-%version%beta

%build
%meson %{?_without_cheese:-Dcheese=false}
%meson_build

%install
%meson_install

%find_lang %name

%files -f %name.lang
%_bindir/%name
%_libexecdir/gnome-contacts-search-provider
%_datadir/applications/%_name.desktop
%_datadir/glib-2.0/schemas/%_name.gschema.xml
%_datadir/dbus-1/services/%_name.service
%_datadir/dbus-1/services/%_name.SearchProvider.service
%_datadir/gnome-shell/search-providers/%_name.search-provider.ini
%_iconsdir/hicolor/*/*/*
%_man1dir/%name.1.*
%_datadir/metainfo/%_name.appdata.xml
%doc NEWS README*

%changelog
