%define ver_major 40
%define xdg_name org.gnome.Dictionary
%define api_ver 1.0

%def_enable man

Name: gnome-dictionary
Version: %ver_major.0
Release: alt1

Summary: Gnome client for MIT dictionary server
Group: Graphical desktop/GNOME
License: LGPLv2.1
Url: https://wiki.gnome.org/Apps/Dictionary

Source: %gnome_ftp/%name/%ver_major/%name-%version.tar.xz

Obsoletes: libgdict < %version

%define glib_ver 2.42.0
%define gtk_ver 3.22.7

BuildRequires(pre): meson rpm-build-gnome
BuildRequires: libappstream-glib-devel desktop-file-utils yelp-tools
BuildRequires: libgio-devel >= %glib_ver libgtk+3-devel >= %gtk_ver
%{?_enable_man:BuildRequires: xsltproc docbook-dtds docbook-style-xsl}

%description
GNOME Dictionary - look up an online dictionary for definitions and
correct spelling of words.

%prep
%setup

%build
%meson -Denable-ipv6=true \
    %{?_disable_man:-Dbuild_man=false}
%nil
%meson_build

%install
%meson_install

%find_lang --with-gnome %name

%files -f %name.lang
%_bindir/%name
%_desktopdir/%xdg_name.desktop
%_datadir/dbus-1/services/%xdg_name.service
%_datadir/glib-2.0/schemas/org.gnome.dictionary.gschema.xml
%_datadir/gdict-%api_ver/
%_iconsdir/hicolor/*/apps/*.svg
%_datadir/metainfo/%xdg_name.appdata.xml
%{?_enable_man:%_man1dir/%name.*}
%doc NEWS README*

%changelog
