%def_disable snapshot
%define _unpackaged_files_terminate_build 1
%define _libexecdir %_prefix/libexec

%define _name swell-foop
%define ver_major 40
%define xdg_name org.gnome.SwellFoop

Name: gnome-games-%_name
Version: %ver_major.1
Release: alt1

Summary: The "Same Game" puzzle
Group: Games/Boards
License: GPLv3+
Url: https://wiki.gnome.org/Apps/Swell-Foop

%if_disabled snapshot
Source: ftp://ftp.gnome.org/pub/gnome/sources/%_name/%ver_major/%_name-%version.tar.xz
%else
Vcs: https://gitlab.gnome.org/GNOME/swell-foop.git
Source: %_name-%version.tar
%endif

Provides:  %_name = %version-%release

%define glib_ver 2.36.0
%define gtk_ver 3.22.23

BuildRequires(pre): meson
BuildRequires: vala-tools
BuildRequires: yelp-tools libappstream-glib-devel desktop-file-utils
BuildRequires: libgio-devel >= %glib_ver libgtk+3-devel >= %gtk_ver libclutter-gtk3-devel
BuildRequires: gsettings-desktop-schemas-devel
BuildRequires: libgnome-games-support-devel

%description
The objective of same-gnome is to remove as many balls from the playing
area in as few moves as possible.

%prep
%setup -n %_name-%version

%build
%meson
%meson_build

%install
%meson_install

%find_lang --with-gnome %_name

%files -f %_name.lang
%attr(-,root,games) %_bindir/%_name
%_desktopdir/%xdg_name.desktop
%_datadir/%_name/
%_iconsdir/hicolor/*x*/apps/%xdg_name.png
%_iconsdir/hicolor/symbolic/apps/%xdg_name-symbolic.svg
%_datadir/dbus-1/services/%xdg_name.service
%config %_datadir/glib-2.0/schemas/%xdg_name.gschema.xml
%_datadir/metainfo/%xdg_name.appdata.xml

%changelog
