%def_disable snapshot

%define ver_major 3.40
%define _libexecdir %_prefix/libexec
%def_enable kerberos
%def_enable owncloud
%def_enable exchange
%def_enable facebook
%def_enable google
%def_enable flickr
%def_enable imap_smtp
%def_enable windows_live
%def_enable media_server
%def_enable foursquare
%def_enable lastfm
%def_enable webkit

%def_enable gtk_doc
%def_enable docs
%define api_ver 1.0

Name: gnome-online-accounts
Version: %ver_major.1
Release: alt1

Summary: Provide online accounts information
Group: Graphical desktop/GNOME
License: LGPL-2.1-or-later
Url: https://wiki.gnome.org/Projects/GnomeOnlineAccounts

%if_enabled snapshot
Source: %name-%version.tar
%else
Source: ftp://ftp.gnome.org/pub/gnome/sources/%name/%ver_major/%name-%version.tar.xz
%endif

Requires: lib%name = %EVR

%{?_enable_kerberos:Requires: realmd}

%define glib_ver 2.52
%define gtk_ver 3.20.0
%define oauth_ver 0.9.5
%define rest_ver 0.7.12
%define soup_ver 2.42
%define webkit_ver 2.8.0

BuildPreReq: glib2-devel >= %glib_ver
BuildPreReq: liboauth-devel >= %oauth_ver
BuildPreReq: librest-devel >= %rest_ver
BuildPreReq: libsoup-devel >= %soup_ver
BuildPreReq: libgtk+3-devel >= %gtk_ver
%{?_enable_webkit:BuildRequires: libwebkit2gtk-devel >= %webkit_ver}
BuildRequires: gnome-common gtk-doc
BuildRequires: libjson-glib-devel libgnome-keyring-devel libnotify-devel libsecret-devel
BuildRequires: libkrb5-devel gcr-libs-devel gobject-introspection-devel
BuildRequires: vala-tools

%description
gnome-online-accounts provides interfaces so applications and
libraries in GNOME can access the user's online accounts.

%package -n lib%name
Summary: %name shared libraries
Group: System/Libraries

%description -n lib%name
This package contains shared %name libraries.

%package -n lib%name-devel
Summary: Development files for %name libraries
Group: Development/C
Requires: lib%name = %EVR

%description -n lib%name-devel
This package contains libraries and header files for developing
applications that use %name libraries.

%package -n lib%name-gir
Summary: GObject introspection data for the %name libraries
Group: System/Libraries
Requires: lib%name = %EVR

%description -n lib%name-gir
GObject introspection data for the %name libraries

%package -n lib%name-gir-devel
Summary: GObject introspection devel data for the %name libraries
Group: Development/Other
BuildArch: noarch
Requires: lib%name-gir = %EVR
Requires: lib%name-devel = %EVR

%description -n lib%name-gir-devel
GObject introspection devel data for the %name libraries

%package -n lib%name-devel-doc
Summary: Development documentation for %name
Group: Development/C
Conflicts: lib%name < %version
BuildArch: noarch

%description -n lib%name-devel-doc
This package contains development documentation for the %name libraries.

%prep
%setup

%build
%if_enabled snapshot
NOCONFIGURE=1 ./autogen.sh
%else
#%autoreconf
%endif
%configure --disable-static \
	--enable-facebook \
	%{subst_enable kerberos} \
	%{subst_enable owncloud} \
	%{?_enable_imap_smtp:--enable-imap-smtp} \
	%{subst_enable exchange} \
	%{subst_enable facebook} \
	%{subst_enable google} \
	%{subst_enable flickr} \
	%{?_enable_windows_live:--enable-windows-live} \
	%{?_enable_media_server:--enable-media-server} \
	%{subst_enable foursquare} \
	%{subst_enable lastfm} \
%if_enabled webkit
	--enable-backend \
%else
	--disable-backend \
%endif
	%{?_enable_gtk_doc:--enable-gtk-doc} \
	%{?_enable_docs:--enable-documentation}

%make_build

%install
%makeinstall_std

%find_lang --output=%name.lang %name %{?_enable_telepathy:%name-tpaw}

%files -f %name.lang
%if_enabled webkit
%_libexecdir/goa-daemon
%_libexecdir/goa-identity-service
%_datadir/glib-2.0/schemas/org.gnome.online-accounts.gschema.xml
%_datadir/dbus-1/services/org.gnome.Identity.service
%_datadir/dbus-1/services/org.gnome.OnlineAccounts.service
%{?_enable_docs:%_man8dir/goa-daemon.*}
%endif
%_iconsdir/hicolor/*/*/*.svg
%{?_enable_telepathy:%_iconsdir/hicolor/scalable/apps/im-*.svg}
%doc README NEWS

%files -n lib%name
%_libdir/libgoa-%api_ver.so.*
%dir %_libdir/goa-%api_ver

%if_enabled webkit
%_libdir/libgoa-backend-%api_ver.so.*
%dir %_libdir/goa-%api_ver/web-extensions
%_libdir/goa-%api_ver/web-extensions/libgoawebextension.so
%exclude %_libdir/goa-%api_ver/web-extensions/*.la
%endif

%files -n lib%name-devel
%_includedir/goa-%api_ver/
%dir %_libdir/goa-%api_ver/include
%_libdir/goa-%api_ver/include/goaconfig.h
%_libdir/libgoa-%api_ver.so

%if_enabled webkit
%_libdir/libgoa-backend-%api_ver.so
%_pkgconfigdir/goa-backend-%api_ver.pc
%endif

%_pkgconfigdir/goa-%api_ver.pc
%_vapidir/goa-%api_ver.deps
%_vapidir/goa-%api_ver.vapi

%files -n lib%name-gir
%_typelibdir/Goa-%api_ver.typelib

%files -n lib%name-gir-devel
%_girdir/Goa-%api_ver.gir

%if_enabled webkit
%files -n lib%name-devel-doc
%_datadir/gtk-doc/html/goa/
%endif

%changelog
