%define _unpackaged_files_terminate_build 1

Name: gnome-quod
Version: 0.2.3
Release: alt4
Summary: Place pieces on a grid so that they make a square
Group: Games/Puzzles
License: GPL3

Source: %name-%version.tar
Patch1: %name-%version-alt-gcc-6.patch
Patch2: %name-%version-alt-gcc-8.patch

# Automatically added by buildreq on Sun Sep 26 2010
BuildRequires: ImageMagick-tools gcc-c++ intltool libgtkmm2-devel librsvg-devel libxml++2-devel

%description
Quod, a game invented by G. Keith Still, has simple rules, but playing well
requires sophisticated strategy. The goal of the game is to place pieces on a
grid so that they make a square. The player who makes a square first wins.
Squares can be any size and orientation, and players have a limited supply of
blocking pieces, which adds to the complexity and interest.

%prep
%setup
%patch1 -p2
%patch2 -p2
sed -i 's/^LF_/# LF_/' configure.ac
for s in 16 32 48 64 128; do convert pixmaps/quod.png -resize ${s}x${s} $s.png; done

%build
%ifarch %e2k
# -std=c++03 by default as of lcc 1.23.20
%add_optflags -std=c++11
%endif
%autoreconf
%configure
%make_build

%install
%makeinstall
for s in 16 32 48 64 128; do 
  install -D $s.png %buildroot%_iconsdir/hicolor/${s}x${s}/apps/quod.png
done

%find_lang %name

%files -f %name.lang
%doc README NEWS THANKS
%_bindir/*
%_desktopdir/%name.desktop
%_pixmapsdir/quod.png
%_pixmapsdir/%name
%_iconsdir/hicolor/*/apps/*
%dir %_datadir/%name
%_datadir/%name/*
%_man6dir/*

%changelog
