%def_disable snapshot

%define ver_major 40
%define beta %nil
%define plugins_ver 16
%define _libexecdir %_prefix/libexec
%define xdg_name org.gnome.Software

%def_enable gspell
%def_enable gudev
%def_enable gnome_desktop
%def_enable polkit
%ifarch armh mipsel %e2k
%def_disable fwupd
%else
%def_enable fwupd
%endif
%def_enable flatpak
%def_disable limba
%def_enable packagekit
%def_enable webapps
%def_enable odrs
# dropped since 3.27.90
%def_disable rpm
%def_disable rpm_ostree
%def_disable external_appstream
%def_enable malcontent
%ifarch %valgrind_arches
%def_enable valgrind
%else
%def_disable valgrind
%endif
%ifarch %e2k
%def_disable sysprof
%else
%def_enable sysprof
%endif
%def_enable tests
%def_disable check

Name: gnome-software
Version: %ver_major.4
Release: alt2%beta

Summary: Software manager for GNOME
License: GPLv2+
Group: Graphical desktop/GNOME
Url: https://wiki.gnome.org/Apps/Software

%if_disabled snapshot
Source: ftp://ftp.gnome.org/pub/gnome/sources/%name/%ver_major/%name-%version%beta.tar.xz
%else
Source: %name-%version.tar
%endif

Patch: %name-3.32.3-alt-unsupported_mime_types.patch

%define glib_ver 2.46
%define gtk_ver 3.22.4
%define appstream_ver 0.14
%define json_glib_ver 1.1.1
%define soup_ver 2.52
%define packagekit_ver 1.1.9
%define gsds_ver 3.18
%define fwupd_ver 1.0.3
%define flatpak_ver 0.99.3
%define ostree_ver 2018.4
%define xmlb_ver 0.1.4
%define handy_ver 0.90

%{?_enable_fwupd:Requires: fwupd >= %fwupd_ver}
%{?_enable_packagekit:Requires: appstream-data}
%{?_enable_malcontent:Requires: malcontent}

BuildRequires(pre): meson rpm-build-xdg rpm-macros-valgrind
BuildRequires: libgio-devel >= %glib_ver
BuildRequires: libgtk+3-devel >= %gtk_ver pkgconfig(libhandy-1) >= %handy_ver
BuildRequires: pkgconfig(appstream) >= %appstream_ver
BuildRequires: libjson-glib-devel >= %json_glib_ver
BuildRequires: libsoup-devel >= %soup_ver
BuildRequires: yelp-tools gtk-doc xsltproc docbook-style-xsl desktop-file-utils
BuildRequires: libsqlite3-devel libsecret-devel gsettings-desktop-schemas-devel liboauth-devel
BuildRequires: libgnome-online-accounts-devel
BuildRequires: libxmlb-devel >= %xmlb_ver
%{?_enable sysprof:BuildRequires: pkgconfig(sysprof-capture-4)}
%{?_enable_gudev:BuildRequires: libgudev-devel}
%{?_enable_gspell:BuildRequires: libgspell-devel}
%{?_enable_gnome_desktop:BuildRequires: gsettings-desktop-schemas >= %gsds_ver}
%{?_enable_polkit:BuildRequires: libpolkit-devel}
%{?_enable_fwupd:BuildRequires: fwupd-devel >= %fwupd_ver}
%{?_enable_flatpak:BuildRequires: libflatpak-devel >= %flatpak_ver}
%{?_enable_packagekit:BuildRequires: libpackagekit-glib-devel >= %packagekit_ver}
%{?_enable_valgrind:BuildRequires: valgrind-tool-devel}
%{?_enable_rpm_ostree:BuildRequires: libostree-devel >= %ostree_ver}
%{?_enable_rpm:BuildRequires: librpm-devel}
%{?_enable_malcontent:BuildRequires: pkgconfig(malcontent-0)}
%{?_enable_check:BuildRequires: gcab}

%description
GNOME Software is a software center for GNOME.

%package devel
Summary: Development files for GNOME Software
Group: Development/GNOME and GTK+
Requires: %name = %version-%release

%description devel
This package contains files necessary to develop plugins for GNOME
Software.

%package devel-doc
Summary: Development documentation for GNOME Software
Group: Development/GNOME and GTK+
BuildArch: noarch
Conflicts: %name-devel < %version

%description devel-doc
This package contains documentation necessary to develop plugins for
GNOME Software.


%prep
%setup -n %name-%version%beta
%patch

%build
%meson \
	%{?_enable_gspell:-Dgspell=true} \
	%{?_enable_gudev:-Dgudev=true} \
	%{?_disable_gnome_desktop:-Dgsettings_desktop_schemas=disabled} \
	%{?_enable_polkit:-Dpolkit=true} \
	%{?_disable_fwupd:-Dfwupd=false} \
	%{?_enable_flatpak:-Dflatpak=true} \
	%{?_enable_ostree:-Dostree=true} \
	%{?_enable_rpm_ostree:-Drpm_ostree=true} \
	%{?_disable_packagekit:-Dpackagekit=false} \
	%{?_disable_valgrind:-Dvalgrind=false} \
	%{?_disable_tests:-Dtests=false} \
	%{?_disable_external_appstream:-Dexternal_appstream=false} \
	%{?_disable_sysprof:-Dsysprof=disabled} \
	%{?_disable_malcontent:-Dmalcontent=false}
%meson_build

%install
%meson_install
%find_lang --with-gnome %name

%check
export LD_LIBRARY_PATH=%buildroot%_libdir
%meson_test

%files -f %name.lang
%_xdgconfigdir/autostart/%name-service.desktop
%_bindir/%name
%_libexecdir/%name-cmd
%_libexecdir/%name-restarter
%{?_enable_external_appstream:%_libexecdir/%name-install-appstream}
%dir %_libdir/%name
%_libdir/%name/libgnomesoftware.so
%_libdir/%name/plugins-%plugins_ver/
%_desktopdir/%name-local-file.desktop
%_desktopdir/%xdg_name.desktop
%_datadir/app-info/xmls/%xdg_name.Featured.xml
%_datadir/dbus-1/services/%xdg_name.service
%{?_enable_packagekit:%_datadir/dbus-1/services/org.freedesktop.PackageKit.service}
%{?_enable_external_appstream:%_datadir/polkit-1/actions/org.gnome.software.external-appstream.policy}
%_datadir/%name/
%_datadir/gnome-shell/search-providers/%xdg_name-search-provider.ini
%_iconsdir/hicolor/*/*/*.svg
%_datadir/glib-2.0/schemas/org.gnome.software.gschema.xml
%_datadir/metainfo/%xdg_name.appdata.xml
#%_datadir/metainfo/%xdg_name.Plugin.Epiphany.metainfo.xml
%{?_enable_flatpak:%_datadir/metainfo/%xdg_name.Plugin.Flatpak.metainfo.xml}
%{?_enable_odrs:%_datadir/metainfo/%xdg_name.Plugin.Odrs.metainfo.xml}
%{?_enable_fwupd:%_datadir/metainfo/%xdg_name.Plugin.Fwupd.metainfo.xml}
%_man1dir/%name.1.*
%doc AUTHORS README* NEWS

%files devel
%_includedir/%name/
%_pkgconfigdir/%name.pc

%files devel-doc
%_datadir/gtk-doc/html/%name/

%changelog
