%define ver_major 3.40
%define xdg_name org.gnome.Terminal
%define _libexecdir %_prefix/libexec

%def_with nautilus

Name: gnome-terminal
Version: %ver_major.3
Release: alt1

Summary: GNOME Terminal
License: GPL-3.0-or-later
Group: Terminals
Url: http://www.gnome.org

Source: ftp://ftp.gnome.org/pub/gnome/sources/%name/%ver_major/%name-%version.tar.xz

%define glib_ver 2.40
%define gtk_ver 3.12.0
%define vte_ver 0.64.2

Provides: xvt

Requires(pre): libvte3 >= %vte_ver
Requires: common-licenses
Requires: dconf gnome-icon-theme

BuildRequires(pre): rpm-macros-alternatives
BuildRequires: rpm-build-gnome gnome-common intltool
BuildRequires: yelp-tools desktop-file-utils libappstream-glib-devel docbook-style-xsl xsltproc
BuildRequires: libgio-devel >= %glib_ver
BuildRequires: libgtk+3-devel >= %gtk_ver
BuildRequires: libvte3-devel >= %vte_ver
BuildRequires: vala-tools
BuildRequires: gsettings-desktop-schemas-devel libSM-devel
BuildRequires: libdconf-devel libuuid-devel
BuildRequires: libpcre2-devel
%{?_with_nautilus:BuildRequires: libnautilus-devel}
# for migration
BuildRequires: libGConf-devel
# %%_datadir/dbus-1/interfaces/org.gnome.ShellSearchProvider2.xml
Buildrequires: gnome-shell-data

%description
GNOME terminal emulator application.

%package nautilus
Summary: Nautilus extension for the GNOME Terminal
Group: Graphical desktop/GNOME
Requires: %name = %version-%release

%description nautilus
This package provides integration with the GNOME Terminal for the
Nautilus file manager.

%prep
%setup

# license
%__rm -f COPYING
%__ln_s -f %_licensedir/GPL-3 COPYING

%build
%add_optflags %(getconf LFS_CFLAGS)
%autoreconf
%configure \
	--disable-static \
	--disable-schemas-compile \
	--disable-dependency-tracking \
	%{?_with_nautilus:--with-nautilus-extension}
%make_build

%install
%makeinstall_std

# alternatives (xterm -- 40)
mkdir -p %buildroot%_altdir
cat >%buildroot%_altdir/%name <<EOF
%_bindir/xvt	%_bindir/%name	39
EOF

%find_lang --with-gnome %name

%files -f %name.lang
%_bindir/%name
%_libexecdir/%name-server
%_prefix/lib/systemd/user/%name-server.service
%_desktopdir/%xdg_name.desktop
%_datadir/dbus-1/services/%xdg_name.service
%config %_datadir/glib-2.0/schemas/%xdg_name.gschema.xml
%dir %_libdir/%name
%_libdir/%name/gschemas.compiled
%_datadir/gnome-shell/search-providers/%name-search-provider.ini
%_iconsdir/hicolor/*/apps/%{xdg_name}*.*
%_datadir/metainfo/%xdg_name.appdata.xml
%_man1dir/%name.1*
%_altdir/%name
%doc --no-dereference COPYING
%doc AUTHORS NEWS

%if_with nautilus
%files nautilus
%nautilus_extdir/libterminal-nautilus.so
%_datadir/metainfo/%xdg_name.Nautilus.metainfo.xml
%exclude %nautilus_extdir/libterminal-nautilus.la
%endif

%changelog
