%define ver_major 3.28

Name: gnome-themes-extra
Version: %ver_major
Release: alt1

Summary: GNOME Extra Themes
License: LGPLv2.1+
Group: Graphical desktop/GNOME
Url: http://www.gnome.org

Source: ftp://ftp.gnome.org/pub/gnome/sources/%name/%ver_major/%name-%version.tar.xz

Obsoletes: gtk2-themes-accessibility
Provides: gtk2-themes-accessibility = %version-%release
Obsoletes: icon-themes-accessibility
Provides: icon-themes-accessibility = %version-%release
Obsoletes: gnome-themes-accessibility
Provides: gnome-themes-accessibility = %version-%release

Obsoletes: gnome-themes-standard < 3.27.90
Provides: gnome-themes-standard = %version-%release

Requires: %name-data = %version-%release

%define theme_prefix gnome-theme
BuildPreReq: intltool >= 0.35.0
BuildRequires: libgtk+3-devel >= 3.13.4 libgtk+2-devel librsvg-devel

%description
This package provides a set of extra GTK+-(2/3) themes, engines,
metacity themes, backgrounds for GNOME 3 desktop.

%package data
Summary: Arch-independent data for %name
Group: Graphical desktop/GNOME
BuildArch: noarch
Requires: gnome-icon-theme >= 3.0.0
# for gtk2 themes
Requires: libgtk-engine-hc
Requires: gtk2-theme-clearlooks

Obsoletes: gnome-themes-standard-data < 3.27.90
Provides: gnome-themes-standard-data = %version-%release

%description data
This package provides an Arch-independent part of %name.

%package -n libgtk2-engine-adwaita
Summary: GTK+2 theme engine Adwaita
Group: Graphical desktop/GNOME

%description -n libgtk2-engine-adwaita
This package provides a GTK+2 theme engine Adwaita.

%prep
%setup
for name in iagno gnome-music gnome-clocks gnome-photos dconf-editor;
do find ./themes/HighContrast/ -name "$name.png" -delete;
done

%build
%configure
%make_build

%install
%makeinstall_std

%find_lang %name

%files
%files data -f %name.lang
%dir %_datadir/themes/Adwaita
%_datadir/themes/Adwaita/index.theme
%dir %_datadir/themes/Adwaita/gtk-2.0
%_datadir/themes/Adwaita/gtk-2.0/gtkrc
%_datadir/themes/Adwaita/gtk-2.0/apps.rc
%_datadir/themes/Adwaita/gtk-2.0/hacks.rc
%_datadir/themes/Adwaita/gtk-2.0/main.rc
%_datadir/themes/Adwaita/gtk-2.0/assets/
%dir %_datadir/themes/Adwaita/gtk-3.0
%_datadir/themes/Adwaita/gtk-3.0/gtk.css
%dir %_datadir/themes/Adwaita-dark/
%_datadir/themes/Adwaita-dark/index.theme
%_datadir/themes/Adwaita-dark/gtk-2.0/
%_datadir/themes/Adwaita-dark/gtk-3.0/

# Accessibility themes from ghome-temes(-default)
%_datadir/themes/HighContrast/gtk-2.0/gtkrc
%_datadir/themes/HighContrast/gtk-3.0/gtk.css
%_datadir/themes/HighContrast/index.theme
%_iconsdir/HighContrast/
%doc NEWS README*

%files -n libgtk2-engine-adwaita
%_libdir/gtk-2.0/2.10.0/engines/libadwaita.so
%exclude %_libdir/gtk-2.0/2.10.0/engines/libadwaita.la

%changelog
