%def_disable snapshot

%define rdn_name org.gnome.Gnote
%define _rdn_name org.gnome.gnote
%define ver_major 40
%define beta %nil
%define _libexecdir %_prefix/libexec
%def_without x11_support
%def_disable check

Name: gnote
Version: %ver_major.2
Release: alt1%beta

Summary: Note-taking application
Group: Graphical desktop/GNOME
License: GPL-3.0-or-later
Url: https://wiki.gnome.org/Apps/Gnote

%if_disabled snapshot
Source: ftp://ftp.gnome.org/pub/gnome/sources/%name/%ver_major/%name-%version%beta.tar.xz
%else
Source: %name-%version.tar
%endif

%define gtk_ver 3.22.20
%define gtkmm_ver 3.18
%define glibmm_ver 2.32
%define gspell_ver 1.6
%define libsecret_ver 0.8

BuildRequires: gcc-c++
BuildRequires: yelp-tools intltool
BuildRequires: pkgconfig(glibmm-2.4)  >= %glibmm_ver
BuildRequires: pkgconfig(gtk+-3.0) >= %gtk_ver
BuildRequires: pkgconfig(x11)
BuildRequires: pkgconfig(gtkmm-3.0) >= %gtkmm_ver
BuildRequires: pkgconfig(glib-2.0) >= 2.32
BuildRequires: pkgconfig(libxml-2.0) pkgconfig(libxslt)
BuildRequires: pkgconfig(gspell-1) >= %gspell_ver
BuildRequires: pkgconfig(libsecret-1) >= %libsecret_ver
BuildRequires: pkgconfig(uuid)
BuildRequires: desktop-file-utils
%{?_enable_check:BuildRequires: libunittest-cpp-devel}

%description
Gnote is a desktop note-taking application which is simple and easy to use.
It lets you organize your notes intelligently by allowing you to easily link
ideas together with Wiki style interconnects. It is a port of Tomboy to C++
and consumes fewer resources.

%prep
%setup -n %name-%version%beta

%build
%configure \
	%{?_with_x11_support:--with-x11-support} \
	--disable-static

%make_build

%install
%makeinstall_std
%find_lang %name --with-gnome

%check
%make check

%files -f %name.lang
%_bindir/%name
%_libdir/libgnote-*.so.*
%_man1dir/%name.*
%_desktopdir/%rdn_name.desktop
%_datadir/%name/
%_iconsdir/hicolor/*/apps/%rdn_name.*
%_libdir/%name/
%exclude %_libdir/%name/addins/*/*.la
%_datadir/dbus-1/services/%rdn_name.service
%_datadir/glib-2.0/schemas/%_rdn_name.gschema.xml
%_datadir/metainfo/%rdn_name.appdata.xml
%_datadir/gnome-shell/search-providers/%rdn_name.search-provider.ini
%doc README TODO NEWS AUTHORS

%exclude %_libdir/lib%name.so
%exclude %_libdir/%name/*/*/*.la

%changelog
