Name: gnustep-gworkspace
Version: 0.9.4
Release: alt3
Summary: The GNUstep Workspace Manager of which the most visible part is the filebrowser
License: GPLv2+
Group: Graphical desktop/GNUstep
Url: http://www.gnustep.org/experience/GWorkspace.html
Packager: Andrey Cherepanov <cas@altlinux.org>

# https://github.com/gnustep/gnustep-gworkspace.git
Source: gworkspace-%version.tar.gz
Source1: %name.menu
Source2: %name.sh
Patch1: link-libs.patch
Patch2: gcc-10.patch

BuildPreReq: gnustep-make-devel gnustep-base-devel /proc
BuildPreReq: libgnustep-pdfkit-devel
BuildPreReq: gnustep-systempreferences-devel libsqlite3-devel unzip
BuildPreReq: gnustep-gui-devel gnustep-gui inotify-tools-devel

Requires: lib%name = %version-%release
Requires: gnustep-systempreferences
Requires: gnustep-back

# File conflict with %_bindir/mdfind
Conflicts: samba-client

%description
GWorkspace is a clone of the NeXT workspace manager with some added
features as spatial viewing, an advanced database based search system,
etc.

%package -n lib%name
Summary: Shared libraries of GWorkspace
Group: System/Libraries

%description -n lib%name
GWorkspace is a clone of the NeXT workspace manager with some added
features as spatial viewing, an advanced database based search system,
etc.

This package contains shared libraries of GWorkspace.

%package -n lib%name-devel
Summary: Development files of GWorkspace
Group: Development/Objective-C
Provides: %name-devel = %version-%release
Requires: %name = %version-%release
Requires: lib%name = %version-%release

%description -n lib%name-devel
GWorkspace is a clone of the NeXT workspace manager with some added
features as spatial viewing, an advanced database based search system,
etc.

This package contains development files of GWorkspace.

%package doc
Summary: Documentation for GWorkspace
Group: Documentation
BuildArch: noarch

%description doc
GWorkspace is a clone of the NeXT workspace manager with some added
features as spatial viewing, an advanced database based search system,
etc.

This package contains documentation for GWorkspace.

%prep
%setup -n gworkspace-%version
%patch1 -p2
%patch2 -p1

%build
. %_datadir/GNUstep/Makefiles/GNUstep.sh

%autoreconf
%configure \
	--libexecdir=%_libdir \
	--enable-gwmetadata \
	--with-inotify \
	--with-installation-domain=SYSTEM

%define incs -I%_libdir/GNUstep/Frameworks/PreferencePanes.framework/Headers
%make_build \
	messages=yes \
	debug=yes \
	strip=no \
	shared=yes \
	AUXILIARY_CPPFLAGS='%incs' \
	CONFIG_SYSTEM_LIBS='-lgnustep-base -lgnustep-gui'
 
libFSNode="$PWD/FSNode/FSNode.framework/libFSNode.so"
pushd Inspector
%make clean
%make_build \
	messages=yes \
	debug=yes \
	strip=no \
	shared=yes \
	AUXILIARY_CPPFLAGS='%incs' \
	CONFIG_SYSTEM_LIBS="$libFSNode -lgnustep-base -lgnustep-gui"
popd

%install
. %_datadir/GNUstep/Makefiles/GNUstep.sh

%makeinstall_std \
	GNUSTEP_INSTALLATION_DOMAIN=SYSTEM

pushd %buildroot%_libdir
for j in MDKit Operation Inspector FSNode; do
	for i in lib$j.so*; do
		rm -f $i
		mv GNUstep/Frameworks/$j.framework/Versions/?/$i ./
		for k in lib$j.so.*.*; do
			for l in 0 1; do
				ln -s %_libdir/$k GNUstep/Frameworks/$j.framework/Versions/$l/$i ||:
				rm GNUstep/Frameworks/$j.framework/Versions/$l/$j ||:
				ln -s %_libdir/$k GNUstep/Frameworks/$j.framework/Versions/$l/$j ||:
			done
		done
	done
done
popd

install -Dp -m644 %SOURCE1 %buildroot%_menudir/%name

rm %buildroot%_bindir/GWorkspace
install -Dp -m755 %SOURCE2 %buildroot%_bindir/GWorkspace
sed -i 's,@PATH@,%_libdir/GNUstep/Applications/GWorkspace.app,' %buildroot%_bindir/GWorkspace

%files
%doc ChangeLog README TODO
%_bindir/*
%_libdir/GNUstep
%exclude %_libdir/GNUstep/Frameworks/*.framework/Versions/?/Headers
%exclude %_libdir/GNUstep/Frameworks/*.framework/Headers
%_menudir/*

%files -n lib%name
%_libdir/*.so.*

%files -n lib%name-devel
%_includedir/*
%_libdir/*.so
%_libdir/GNUstep/Frameworks/*.framework/Versions/?/Headers
%_libdir/GNUstep/Frameworks/*.framework/Headers

%files doc
%doc Documentation/*

%changelog
