Name: gstatus
Version: 0.64
Release: alt2

Summary: Show the current health of the component in a glusterfs Trusted Storage Pool
License: GPLv3
Group: System/Base
Url: https://github.com/pcuzner/gstatus
Packager: Vitaly Lipatov <lav@altlinux.ru>

BuildArch: noarch

# Source-url: https://github.com/pcuzner/gstatus/archive/v%version.tar.gz
Source: %name-%version.tar
Patch0: port-to-python3.patch

BuildRequires(pre): rpm-build-python3

Requires: %_sbindir/gluster

%add_python3_req_skip gstatus.classes.gstatus_cli
%add_python3_req_skip gstatus.functions.config
%add_python3_req_skip gstatus.functions.network
%add_python3_req_skip gstatus.functions.utils

%description
CLI command to provide a status check on the cluster's health, providing
a view of node, volume state (up, degraded, partial or down), brick
up/down states and capacity information by volume (usable, used).

In addition to the interactive model, a json or keyvalue output option
is also available through '-o json|keyvalue'. By utilising -o, you can
log the state of the cluster to a file, and interpret with Splunk,
Logstash or nagios/zabbix.

Errors detected, are listed in plain english together and provide an
easy way to assess the impact to a service, following a disruptive event
that affects the trusted pool.

%prep
%setup
%patch0 -p2

%build
%python3_build_debug

%install
%python3_install --install-scripts %_bindir

%files
%doc README
%_bindir/gstatus
%python3_sitelibdir_noarch/gstatus/
%python3_sitelibdir_noarch/gstatus-%version-*.egg-info/
#%_man8dir/gstatus.*

%changelog
