%define ver_major 0.10
%define _libexecdir %_prefix/libexec

Name: gstreamer%ver_major
Version: %ver_major.36
Release: alt2
Summary: GStreamer streaming media framework runtime (legacy version)
License: LGPL
Group: System/Libraries
URL: http://gstreamer.freedesktop.org
Packager: Andrey Cherepanov <cas@altlinux.org>

Requires: lib%name = %version-%release

Source: gstreamer-%version.tar
Source1: common.tar
Patch: gstreamer-%version-%release.patch
Patch1: gstreamer-0.10.36-bison3.patch

BuildRequires: docbook-utils flex gcc-c++ ghostscript-utils glib2-devel gtk-doc intltool libcheck-devel libxml2-devel
BuildRequires: python-modules sgml-common transfig xml-utils gobject-introspection-devel

%description
GStreamer is a streaming-media framework, based on graphs of filters which
operate on media data. Applications using this library can do anything
from real-time sound processing to playing videos, and just about anything
else media-related.  Its plugin-based architecture means that new data
types or processing capabilities can be added simply by installing new
plugins.

%package -n lib%name
Summary: Shared libraries of GStreamer (legacy version)
Group: System/Libraries

%description -n lib%name
This package contains the shared libraries of the GStreamer media framework

%package -n lib%name-gir
Summary: GObject introspection data for the GStreamer library (legacy version)
Group: System/Libraries
Requires: lib%name = %version-%release

%description -n lib%name-gir
GObject introspection data for the GStreamer library

%package devel
Summary: Development files for GStreamer streaming-media framework (legacy version)
Group: Development/C
Requires: lib%name = %version-%release

%description devel
This package contains the libraries and header files necessary to
develop applications and plugins for GStreamer

%package gir-devel
Summary: GObject introspection devel data for the GStreamer library (legacy version)
Group: System/Libraries
BuildArch: noarch
Requires: lib%name-gir = %version-%release %name-devel = %version-%release

%description gir-devel
GObject introspection devel data for the GStreamer library

%prep
%setup -q -a1 -n gstreamer-%version
%patch -p1
%patch1 -p1

touch ABOUT-NLS config.rpath
subst '/.PHONY/d' Makefile.am

%build
%autoreconf
%configure \
	--with-package-name=GStreamer \
	--with-package-origin=%name \
	--disable-examples \
	--disable-valgrind \
	--disable-docbook \
	--disable-gtk-doc \
	--disable-rpath \
	--disable-tests \
	--disable-debug \
	--disable-static

%make_build

%install
%make DESTDIR=%buildroot install

%find_lang %name-%ver_major

%files -f %name-%ver_major.lang
%doc AUTHORS NEWS README RELEASE
%_libexecdir/gstreamer-%ver_major
%dir %_libdir/gstreamer-%ver_major
%_libdir/gstreamer-%ver_major/*.so

%files -n lib%name
%_libdir/*.so.*

%files -n lib%name-gir
%_libdir/girepository-1.0/*.typelib

%files devel
%_includedir/*
%_libdir/*.so
%_pkgconfigdir/*.pc
%_datadir/aclocal/*

%files gir-devel
%_datadir/gir-1.0/*.gir

%changelog
