%define py3bdir ../%name-%version-python3-build
%define realversion 2.3.0

Name: httpie
Version: 2.3.0
Release: alt3

Summary: A Curl-like tool for humans
Group: Networking/WWW
License: BSD
Url: http://httpie.org
BuildArch: noarch

Source0: %name-%version.tar

BuildRequires(pre): rpm-build-python3
BuildRequires: python3-dev python3-module-setuptools
BuildRequires: python3-module-Pygments python3-module-requests
BuildRequires: help2man

Requires: python3-module-requests >= 2.11.0
Requires: python3-module-Pygments >= 2.1.3
Requires: python3-module-socks

Obsoletes: httpie-python3 < %EVR

%description
HTTPie is a CLI HTTP utility built out of frustration with existing tools. The
goal is to make CLI interaction with HTTP-based services as human-friendly as
possible.

HTTPie does so by providing an http command that allows for issuing arbitrary
HTTP requests using a simple and natural syntax and displaying colorized
responses.

%prep
%setup

sed -i 's|#!/usr/bin/env python|#!/usr/bin/env python3|' \
    $(find ./ -name '*.py')

%build
%__python3 setup.py build

%install
%__python3 setup.py install --skip-build --root %buildroot

mkdir -p %buildroot/%_man1dir

export PYTHONPATH=%buildroot%python3_sitelibdir
help2man --no-discard-stderr %buildroot/%_bindir/http > %buildroot/%_man1dir/http.1
help2man --no-discard-stderr %buildroot/%_bindir/https > %buildroot/%_man1dir/https.1

%files
%_bindir/http
%_bindir/https
%python3_sitelibdir/%name
%python3_sitelibdir/%name-%{realversion}*
%_man1dir/http.1*
%_man1dir/https.1*
%doc LICENSE README.rst


%changelog
