%define gobuild go build

# TODO: build with external sources

Name: hub
Version: 2.14.2
Release: alt1

Summary: A command-line wrapper for git with github shortcuts

Group: Development/Tools
License: MIT
Url: http://hub.github.com/

Packager: Vitaly Lipatov <lav@altlinux.ru>

# Source-url: https://github.com/github/hub/archive/v%version.tar.gz
Source: %name-%version.tar

BuildRequires(pre): rpm-macros-golang
ExclusiveArch: %go_arches

BuildRequires: golang >= 1.7
# for man and help
BuildRequires: ronn

BuildRequires: /usr/bin/groff

BuildRequires: git-core

#BuildRequires: golang(gopkg.in/yaml.v1)
#BuildRequires: golang(github.com/bmizerany/assert)
#BuildRequires: golang(github.com/BurntSushi/toml)
#BuildRequires: golang(github.com/howeyc/gopass)
#BuildRequires: golang(github.com/kballard/go-shellquote)
#BuildRequires: golang(github.com/mitchellh/go-homedir)

Requires: git-core vim-common

#Provides: bundled(golang(github.com/inconshreveable/go-update))
#Provides: bundled(golang(github.com/mattn/go-colorable))
#Provides: bundled(golang(github.com/mattn/go-isatty))
#Provides: bundled(golang(github.com/octokit/go-octokit))
#Provides: bundled(golang(github.com/ogier/pflag))

%description
hub is a command line tool that wraps `git` in order to extend it with extra
features and commands that make working with GitHub easier.

    $ hub clone rtomayko/tilt

    # expands to:
    $ git clone git://github.com/rtomayko/tilt.git

%prep
%setup

#rm -rf vendor/gopkg.in/yaml.v1 \
#       vendor/github.com/bmizerany/assert \
#       vendor/github.com/BurntSushi/toml \
#       vendor/github.com/howeyc/gopass \
#       vendor/github.com/kballard/go-shellquote \
#       vendor/github.com/mitchellh/go-homedir

# TODO: macro
#mkdir -p Godeps/src/github.com/github
#ln -snf $(pwd) Godeps/src/github.com/github/hub

%build
#export GOPATH=$(pwd)/Godeps:%go_path
#gobuild -o bin/%name -ldflags '-X github.com/github/hub/version.Version=%version'
make

# use system ronn, skip build from Internet
ln -s %_bindir/ronn bin/ronn

# col needs UTF-8 locale for UTF-8 input
# https://github.com/karelzak/util-linux/issues/1198
export LANG=en_US.UTF-8
make man-pages

%install
# /bin/hub
#install -D -p -m 755 bin/%name %buildroot%_bindir/%name
make install PREFIX=%buildroot%_prefix

# Documentation
#install -d -m 755 %buildroot%_man1dir/
#cp -p man/hub.1 %buildroot%_man1dir/.
mv %buildroot%_docdir/hub-doc %buildroot%_docdir/hub

# Bash-completion
install -d -m 755 %buildroot%_sysconfdir/bash_completion.d/
cp -p etc/hub.bash_completion.sh %buildroot%_sysconfdir/bash_completion.d/.

# ZSH-completion
install -d -m 755 %buildroot%_datadir/zsh/site-functions/
cp -p etc/hub.zsh_completion %buildroot%_datadir/zsh/site-functions/_hub

%check

%if_with tests
# Tests are currently nonfunctional in mock
# All calls to 'git' are failing to find a valid repo, but
# they work when run outside of mock.

export GOPATH=$(pwd):$(pwd)/Godeps:%gopath

find . -maxdepth 2 -name '*.go' '!' -name '*_test.go' | \
  cut -d/ -f2 | sort -u | grep -v '.go$' | sed 's!^!github.com/github/hub/!' | \
  xargs go test -v
%endif

%files
%doc LICENSE
%doc README.md CONTRIBUTING.md
#doc man/hub.1.html man/hub.1.ronn
%doc %_docdir/hub/
%_bindir/hub
%_man1dir/*
%_sysconfdir/bash_completion.d/
%_datadir/zsh/site-functions/_hub
/usr/share/vim/vimfiles/ftdetect/pullrequest.vim
/usr/share/vim/vimfiles/syntax/pullrequest.vim

%changelog
