# force to use GDK_BACKEND=x11 while wxWidgets wxGLCanvas
# do not support Wayland
%def_enable gdk_x11
# Python scripting interface disabled by default since 2018.0.0
%def_enable hsi
# lapack support disabled by default
%def_disable lapack

Name: hugin
Version: 2020.0.0
Release: alt1

Summary: hugin - Goal: an easy to use cross-platform GUI for Panorama Tools.
Group: Graphics
License: GPLv2+
Url: https://hugin.sourceforge.net/

#tarball: https://downloads.sourceforge.net/%name/%name-%version.tar.bz2
Source: %name-%version.tar
Patch1: Add-translations-in-desktop-files.patch

%define boost_ver 1.54
%define pano_ver 2.9.19
%define wx_ver 3.0.0
%define enblend_ver 3.2

Requires: libpano13 >= %pano_ver
Requires: enblend >= %enblend_ver
Requires: autopano-sift-C perl-Image-ExifTool make

BuildRequires(pre): rpm-macros-cmake
BuildRequires: cmake gcc-c++ gcc-fortran libgomp-devel
BuildRequires: libpano13-devel >= %pano_ver libwxGTK3.0-devel >= %wx_ver
BuildRequires: boost-devel >= %boost_ver boost-thread-devel boost-devel boost-thread-devel
BuildRequires: boost-datetime-devel boost-regex-devel boost-filesystem-devel boost-iostreams-devel
BuildRequires: boost-system-devel boost-signals-devel
BuildRequires: libXi-devel libXmu-devel libglew-devel
BuildRequires: libjpeg-devel libpng-devel libtiff-devel libexiv2-devel
BuildRequires: liblensfun-devel liblcms2-devel libvigra-devel
BuildRequires: zlib-devel libpango-devel openexr-devel libtclap-devel
BuildRequires: libfftw3-devel libsqlite3-devel
BuildRequires: libflann-devel
%if_enabled hsi
BuildRequires(pre): rpm-build-python3
BuildRequires: python3-devel swig
%add_python3_path %_datadir/%name/data/plugins*
%endif
%{?_enable_lapack:BuildRequires: liblapack-devel}
BuildRequires: desktop-file-utils libappstream-glib-devel perl-podlators

%description
With hugin you can assemble a mosaic of photographs into a complete immersive
panorama, stitch any series of overlapping pictures and much more.

%prep
%setup
%patch1 -p2

%build
# reenable RPTHs because libraries in private subdirectory
%cmake -DINSTALL_XRC_DIR="/usr/share/hugin/xrc" \
	-DCMAKE_SKIP_RPATH:BOOL=OFF \
	-DCMAKE_SKIP_INSTALL_RPATH:BOOL=OFF \
	%{?_enable_gdk_x11:-DUSE_GDKBACKEND_X11:BOOL=ON} \
	%{?_enable_hsi:-DBUILD_HSI:BOOL=ON} \
	%{?_enable_lapack:-DENABLE_LAPACK:BOOL=ON} \
	-DPYTHON_EXECUTABLE=%__python3
%cmake_build

%install
%cmakeinstall_std
%find_lang --output=%name.lang %name nona_gui
/bin/install -p -m644 -D src/hugin1/hugin/xrc/data/hugin.png %buildroot%_datadir/pixmaps/%name.png
/bin/install -p -m644 -D src/hugin1/hugin/xrc/data/hugin.png %buildroot%_niconsdir/%name.png

for file in hugin PTBatcherGUI calibrate_lens_gui pto_gen; do
desktop-file-install --dir %buildroot%_desktopdir \
	--add-category=Photography \
	%buildroot%_desktopdir/$file.desktop
done

%files -f %name.lang
%doc AUTHORS README
%_bindir/*
%_desktopdir/*.desktop
%_datadir/%name/
%_datadir/pixmaps/*
%_datadir/mime/packages/hugin.xml
%_libdir/%name/
%{?_enable_hsi:%python3_sitelibdir/*}
%_iconsdir/gnome/48x48/mimetypes/application-x-ptoptimizer-script.png
%_iconsdir/hicolor/*x*/apps/*.png
%_iconsdir/hicolor/scalable/apps/*.svg
%_man1dir/*
%_datadir/metainfo/PTBatcherGUI.appdata.xml
%_datadir/metainfo/calibrate_lens_gui.appdata.xml
%_datadir/metainfo/%name.appdata.xml

%changelog
