Name: hyphen
Summary: A text hyphenation library
Version: 2.8.8
Release: alt1
License: LGPLv2+ or MPLv1.1
Group: System/Libraries
URL: http://hunspell.sourceforge.net/
Packager: Valery Inozemtsev <shrek@altlinux.ru>

Source: http://downloads.sourceforge.net/hunspell/%name-%version.tar.gz

BuildRequires: gcc-c++

%description
Hyphen is a library for high quality hyphenation and justification

%package -n lib%name
Summary: A text hyphenation library
Group: System/Libraries

%description -n lib%name
Hyphen is a library for high quality hyphenation and justification

%package -n lib%name-devel
Summary: Files for developing with hyphen
Group: Development/C++
Requires: lib%name = %version-%release

%description -n lib%name-devel
Includes and definitions for developing with hyphen

%package en
Summary: English hyphenation rules
Group: Text tools
Requires: lib%name

%description en
English hyphenation rules

%prep
%setup -q

%build
%configure \
	--disable-static
%make_build

%install
%make DESTDIR=%buildroot install

cd %buildroot%_datadir/hyphen/
en_US_aliases="en en_AU en_BS en_BZ en_CA en_GH en_GB en_IE en_IN en_JM en_NA en_NZ en_PH en_TT en_ZA en_ZW"
for lang in $en_US_aliases; do
        ln -s hyph_en_US.dic hyph_$lang.dic
done

%files -n lib%name
%doc AUTHORS README README.* THANKS TODO
%_libdir/*.so.*
%dir %_datadir/hyphen

%files -n lib%name-devel
%_includedir/hyphen.h
%_bindir/substrings.pl
%_libdir/*.so

%files en
%doc README_hyph_en_US.txt
%_datadir/hyphen/hyph_en*.dic

%changelog
