%define mpiimpl openmpi
%define mpidir %_libdir/%mpiimpl

%define somver 0
%define sover %somver.2.20

# TODO: improve me
%def_without docs

Name: hypre
Version: 2.20.0
Release: alt1.1

Summary: Scalable algorithms for solving linear systems of equations

License: LGPLv2.1
Group: Sciences/Mathematics
Url: http://www.llnl.gov/casc/hypre/

# Source-url: https://github.com/hypre-space/hypre/archive/v%version.tar.gz
Source: %name-%version.tar
Patch: hypre-2.20.0-shared.patch

BuildRequires(pre): rpm-build-java rpm-macros-cmake /proc
BuildRequires: gcc-fortran gcc-c++ %mpiimpl-devel emacs-nox
BuildRequires: liblapack-devel netpbm
BuildRequires: libsuperlu-devel babel cmake texlive-base-bin
BuildRequires: java-devel-default
BuildRequires: libnumpy-devel libxml2-devel
# python-module-libxml2
BuildRequires: libltdl-devel ghostscript-classic

%description
The goal of the Scalable Linear Solvers project is to develop scalable
algorithms and software for solving large, sparse linear systems of equations on
parallel computers. The primary software product is Hypre, a library of high
performance preconditioners that features parallel multigrid methods for both
structured and unstructured grid problems. The problems of interest arise in the
simulation codes being developed at LLNL and elsewhere to study physical
phenomena in the defense, environmental, energy, and biological sciences.

%package -n lib%name
Summary: Shared libraries of Hypre
Group: System/Libraries

%description -n lib%name
The goal of the Scalable Linear Solvers project is to develop scalable
algorithms and software for solving large, sparse linear systems of equations on
parallel computers. The primary software product is Hypre, a library of high
performance preconditioners that features parallel multigrid methods for both
structured and unstructured grid problems. The problems of interest arise in the
simulation codes being developed at LLNL and elsewhere to study physical
phenomena in the defense, environmental, energy, and biological sciences.

This package contains shared libraries of Hypre.

%package -n lib%name-devel
Summary: Development files of Hypre
Group: Development/Other
Requires: libbabel-devel libltdl7-devel libsuperlu-devel
Requires: lib%name = %version-%release
Provides: %name = %version-%release
Obsoletes: %name

%description -n lib%name-devel
The goal of the Scalable Linear Solvers project is to develop scalable
algorithms and software for solving large, sparse linear systems of equations on
parallel computers. The primary software product is Hypre, a library of high
performance preconditioners that features parallel multigrid methods for both
structured and unstructured grid problems. The problems of interest arise in the
simulation codes being developed at LLNL and elsewhere to study physical
phenomena in the defense, environmental, energy, and biological sciences.

This package contains development files of Hypre.

%package -n lib%name-devel-doc
Summary: Development documentation for Hypre
Group: Development/Documentation
BuildArch: noarch

%description -n lib%name-devel-doc
The goal of the Scalable Linear Solvers project is to develop scalable
algorithms and software for solving large, sparse linear systems of equations on
parallel computers. The primary software product is Hypre, a library of high
performance preconditioners that features parallel multigrid methods for both
structured and unstructured grid problems. The problems of interest arise in the
simulation codes being developed at LLNL and elsewhere to study physical
phenomena in the defense, environmental, energy, and biological sciences.

This package contains development documentation for Hypre.

%prep
%setup
%patch -p2

%build
mpi-selector --set %mpiimpl --yes
source /etc/profile.d/mpi-selector.sh
source %mpidir/bin/mpivars.sh
export OMPI_LDFLAGS="-Wl,--as-needed,-rpath=%mpidir/lib -L%mpidir/lib"

export includedir=%_includedir
export JNI_INCLUDES="%_libexecdir/jvm/java/include"
export MPIDIR=%mpidir
cd src

%add_optflags %optflags %optflags_shared -I%_includedir/numpy

# TODO: CMakeFiles was rewritten and broken since 2.20
%cmake \
	-DHYPRE_ENABLE_SHARED=ON \
	-DCMAKE_VERBOSE_MAKEFILE:BOOL=ON \
	-DCMAKE_STRIP:FILEPATH="/bin/echo" \
	-DHYPRE_INSTALL_PREFIX:PATH=%buildroot%prefix \
	-DMPIDIR=%mpidir \
	-DSOMVER=%somver \
	-DSOVER=%sover \
	-DHYPRE_USING_HYPRE_BLAS:BOOL=OFF \
	-DHYPRE_USING_HYPRE_LAPACK:BOOL=OFF \
	..

%cmake_build

%install
source %mpidir/bin/mpivars.sh
export OMPI_LDFLAGS="-Wl,--as-needed,-rpath=%mpidir/lib -L%mpidir/lib"
cd src

%cmake_install

install -d %buildroot%_includedir/%name
mv %buildroot%_includedir/*.h %buildroot%_includedir/%name/

%if_with docs
install -d %buildroot%_docdir/lib%name-devel-doc
cp -fR ../../docs/* %buildroot%_docdir/lib%name-devel-doc/
%endif

rm -f %buildroot%_libdir/libsidl*

%files -n lib%name
%_libdir/lib*.so.0
%_libdir/lib*.so.%sover

%files -n lib%name-devel
%doc README.md SUPPORT.md CHANGELOG NOTICE LICENSE* COPYRIGHT
%_libdir/lib*.so
%_includedir/%name/
%_libdir/cmake/HYPRE/

%if_with docs
%files -n lib%name-devel-doc
%_docdir/lib%name-devel-doc
%endif

%changelog
