%define _unpackaged_files_terminate_build 1
%define pname integalert

# Using ifarch instead of ExclusiveArch tag in order to make
# the other packages available on non-PVE arches.
%ifarch x86_64 aarch64
%def_with pve
%else
%def_without pve
%endif


Name:     %pname-source
Version:  0.4.8
Release:  alt1

Summary:  Osec-based integrity checking script and settings
License:  GPLv2
Group:    Monitoring
Url:      http://git.altlinux.org/people/manowar/packages/integalert.git

Packager: Paul Wolneykien <manowar@altlinux.org>
Source:   %name-%version.tar

%description
Osec-based integrity checking script and settings.

%package -n %pname
Summary:  Osec-based integrity checking script and settings
Group:    Monitoring
BuildArch: noarch

Requires: systemd
Requires: osec-cronjob >= 1.3.1-alt2

Obsoletes: integ < 0.4.2-alt2

%description -n %pname
Osec-based integrity checking script and settings.
Includes the 'integalert.service' that is configured to run
before 'sysinit.target' on every boot.

Activates the special 'integ-check-failed.target' on failure.

%package -n installer-feature-integalert-stage2
Summary: Run integrity check after install (installer files)
Group: System/Configuration/Other
BuildArch: noarch

%description -n installer-feature-integalert-stage2
Run integrity check after install (installer files).

%package -n installer-feature-integalert-stage3
Summary: Run integrity check after install (chroot files)
Group: System/Configuration/Other
Requires: integalert = %version-%release
BuildArch: noarch

%description -n installer-feature-integalert-stage3
Run integrity check after install (chroot files).

%package -n %pname-vm-check
Summary: Run VM integrity check before PVE and/or Libvirtd start and then every 5 mins
Group: Monitoring
BuildArch: noarch

%description -n %pname-vm-check
Includes a service that is configured to run 'integalert vm' and
'integalert container' before 'pvedaemon.service' and
'libvirtd.service', and every 5 mins after that (using a timer).

Activates the special 'vm-check-failed.target' on failure.

%package -n %pname-trigger-pve
Summary: Lock down PVE cluster VMs on integrity failure
Group: Monitoring

%description -n %pname-trigger-pve
Lock down PVE cluster VMs on integalert_vm.service failure.

%prep
%setup

%build
%make_build

%install
%makeinstall_std sbindir=/sbin sysconfdir=%_sysconfdir datadir=%_datadir unitdir=%_unitdir  presetdir=/lib/systemd/system-preset WITH_PVE=%{with pve}

%post -n %pname
# On package update (don't check the $1 value due to package
# rename):
if systemctl -q is-enabled integalert.service; then
    systemctl daemon-reload
    systemctl -q preset integalert.service
fi

# On first installation, try to migrate from existing
# configuration not maintained by RPM:
if [ $1 -eq 1 ]; then
    for d in integalert integalert_vm integalert_container; do
	for f in pipe.conf; do
	    if [ -e "%_sysconfdir/osec/$d/$f.rpmnew" ]; then
		if [ -e "%_sysconfdir/osec/$d/$f.rpmold" ]; then
		    mv -vf "%_sysconfdir/osec/$d/$f.rpmold" \
		       "$(mktemp %_sysconfdir/osec/$d/$f.rpmold.XXX)"
		fi

		mv -vf "%_sysconfdir/osec/$d/$f" \
		   "%_sysconfdir/osec/$d/$f.rpmold"
		mv -vf "%_sysconfdir/osec/$d/$f.rpmnew" \
		   "%_sysconfdir/osec/$d/$f"

		echo "Warning! %_sysconfdir/osec/$d/$f.rpmnew was automatically re-installed as %_sysconfdir/osec/$d/$f. Existing file has been saved as %_sysconfdir/osec/$d/$f.rpmold." >&2
	    fi
	done

	if [ -d %_sysconfdir/osec/${d}_fix ]; then
	    ls %_sysconfdir/osec/${d}_fix | while read f; do
		if [ -e "%_sysconfdir/osec/$d/$f.fix.rpmold" ]; then
		    mv -vf "%_sysconfdir/osec/$d/$f.fix.rpmold" \
		       "$(mktemp %_sysconfdir/osec/$d/$f.fix.rpmold.XXX)"
		fi

		mv -vf "%_sysconfdir/osec/${d}_fix/$f" \
		   "%_sysconfdir/osec/${d}/$f.fix.rpmold"
	    done

	    rmdir -v %_sysconfdir/osec/${d}_fix

	    echo "Warning! Files in %_sysconfdir/osec/${d}_fix were automatically saved as *.fix.rpmold files in %_sysconfdir/osec/$d." >&2
	fi
    done
fi

%files -n installer-feature-integalert-stage2
%_datadir/install2/postinstall.d/90-integrity-init.sh

%files -n installer-feature-integalert-stage3

%files -n %pname
%_unitdir/integalert.service
/lib/systemd/system-preset/65-integrity.preset
/sbin/integalert
%dir %_sysconfdir/osec/integalert*
%config(noreplace) %_sysconfdir/osec/integalert*/*.conf
%_sysconfdir/osec/integalert*/sender
%dir %_sysconfdir/osec/integalert*/trigger.d

%files -n %pname-vm-check
%_unitdir/integalert_vm.service
%_unitdir/integalert_vm.timer

%if_with pve
%files -n %pname-trigger-pve
%_sysconfdir/osec/integalert_vm/trigger.d/*-pve-*
%endif

%changelog
