%define _unpackaged_files_terminate_build 1

%define oname ipython

%def_without doc

Name: ipython
Version: 5.5.0
Release: alt8

%setup_python_module IPython

Summary: An enhanced interactive Python shell
License: BSD
Group: Development/Python

Url: https://ipython.org
BuildArch: noarch

# https://github.com/ipython/ipython.git
Source: %name-%version.tar
Patch1: %name-%version-alt-docs.patch

%add_findreq_skiplist %python_sitelibdir/IPython/utils/eventful.py
%add_findreq_skiplist %python3_sitelibdir/IPython/utils/eventful.py

BuildRequires: python-module-setuptools
%if_with doc
BuildRequires: python-module-sphinx-devel python-module-matplotlib-sphinxext python-module-numpydoc
BuildRequires: python2.7(sphinx_rtd_theme) graphviz
%endif

Requires: python-module-%oname

%description
IPython provides a replacement for the interactive Python interpreter with
extra functionality.

Main features:
* Comprehensive object introspection.
* Input history, persistent across sessions.
* Caching of output results during a session with automatically generated
  references.
* Readline based name completion.
* Extensible system of 'magic' commands for controlling the environment and
  performing many tasks related either to IPython or the operating system.
* Configuration system with easy switching between different setups (simpler
  than changing $$PYTHONSTARTUP environment variables every time).
* Session logging and reloading.
* Extensible syntax processing for special purpose situations.
* Access to the system shell with user-extensible alias system.
* Easily embeddable in other Python programs.
* Integrated access to the pdb debugger and the Python profiler.

%package doc
Summary: IPython documentation
Group: Development/Python

%description doc
IPython provides a replacement for the interactive Python interpreter with
extra functionality.

This package contains IPython documentation (html and PDF formats).

%package examples
Summary: IPython examples
Group: Development/Python

%description examples
IPython provides a replacement for the interactive Python interpreter with
extra functionality.

This package contains examples for IPython.

%package -n python-module-%oname
Summary: An enhanced interactive Python shell
Group: Development/Python

%add_python_req_skip Gnuplot Numeric bzrlib foolscap nose setuptools twisted msvcrt oct2py rpy2 System builtins clr
#py_requires jsonschema traitlets pexpect simplegeneric
#py_requires pathlib2
# fake due exaile
%py_provides IPython
# fake due BALL
%py_provides ipykernel

%description -n python-module-%oname
IPython provides a replacement for the interactive Python interpreter with
extra functionality.

This package contains modules for Python-2.

%package -n python-module-%oname-tests
Summary: An enhanced interactive Python shell
Group: Development/Python

%description -n python-module-%oname-tests
IPython provides a replacement for the interactive Python interpreter with
extra functionality.

This package contains tests for Python-2.

%prep
%setup
%patch1 -p1

%if_with doc
%prepare_sphinx docs
ln -s ../objects.inv docs/source/
%endif

%build
#python_build

%install
mkdir -p %buildroot
#python_install
#rm %buildroot%_bindir/iptest

%if_with doc
install -d %buildroot%_docdir/%name
cp docs/source/*.txt %buildroot%_docdir/%name/

export PYTHONPATH=%buildroot%python_sitelibdir
%make -C docs html PYTHON=python
cp -R docs/build/html/* examples %buildroot%_docdir/%name/
%endif

%files -n python-module-%oname
#%python_sitelibdir/IPython/
#%python_sitelibdir/*.egg-info
#%exclude %python_sitelibdir/IPython/*/tests

#%files -n python-module-%oname-tests
#%python_sitelibdir/IPython/*/tests

%if_with doc
%files doc
%_docdir/%name
%exclude %_docdir/%name/*.txt
%exclude %_docdir/%name/examples
#_docdir/%name/manual/

%files examples
%dir %_docdir/%name
%_docdir/%name/examples
%endif

%changelog
