%define _unpackaged_files_terminate_build 1

# stable branches support uses this macro
%define qIF_ver_lt() %if "%(rpmvercmp '%2' '%1')" > "0"

%qIF_ver_lt %ubt_id S1
%define _cmake__builddir BUILD
%endif

%define itkver 5.1

Name: itk
Version: %itkver.2
Release: alt5

Group: System/Libraries
Summary: Toolkit for N-dimensional scientific image processing, segmentation, and registration.
License: Apache-2.0
Url: https://itk.org

# https://github.com/InsightSoftwareConsortium/ITK
Source: %name-%version.tar

# Modules generated by update-remote-modules.sh
Source100: %name-%version-AnalyzeObjectLabelMap.tar
Source101: %name-%version-AnisotropicDiffusionLBR.tar
Source102: %name-%version-BioCell.tar
Source103: %name-%version-BoneEnhancement.tar
Source104: %name-%version-BoneMorphometry.tar
Source105: %name-%version-BSplineGradient.tar
Source106: %name-%version-Cuberille.tar
Source107: %name-%version-NeuralNetworks.tar
Source108: %name-%version-FixedPointInverseDisplacementField.tar
Source109: %name-%version-GenericLabelInterpolator.tar
Source110: %name-%version-HigherOrderAccurateGradient.tar
Source111: %name-%version-IOFDF.tar
Source112: %name-%version-IOMeshSTL.tar
Source113: %name-%version-IOOpenSlide.tar
Source114: %name-%version-IOScanco.tar
Source115: %name-%version-IOTransformDCMTK.tar
Source116: %name-%version-IsotropicWavelets.tar
Source117: %name-%version-LabelErodeDilate.tar
Source118: %name-%version-LesionSizingToolkit.tar
Source119: %name-%version-MeshNoise.tar
Source120: %name-%version-MGHIO.tar
Source121: %name-%version-MinimalPathExtraction.tar
Source122: %name-%version-Montage.tar
Source123: %name-%version-MorphologicalContourInterpolation.tar
Source124: %name-%version-MultipleImageIterator.tar
Source125: %name-%version-ParabolicMorphology.tar
Source126: %name-%version-PerformanceBenchmarking.tar
Source127: %name-%version-PhaseSymmetry.tar
Source128: %name-%version-PolarTransform.tar
Source129: %name-%version-PrincipalComponentsAnalysis.tar
Source130: %name-%version-RLEImage.tar
Source131: %name-%version-RTK.tar
Source132: %name-%version-SimpleITKFilters.tar
Source133: %name-%version-SkullStrip.tar
Source134: %name-%version-SmoothingRecursiveYvvGaussianFilter.tar
Source135: %name-%version-SplitComponents.tar
Source136: %name-%version-Strain.tar
Source137: %name-%version-SubdivisionQuadEdgeMeshFilter.tar
Source138: %name-%version-TextureFeatures.tar
Source139: %name-%version-Thickness3D.tar
Source140: %name-%version-TubeTK.tar
Source141: %name-%version-TwoProjectionRegistration.tar
Source142: %name-%version-VariationalRegistration.tar

Patch: %name-%version-alt.patch

Patch1: %name-%version-RTK.patch
Patch2: %name-%version-VariationalRegistration.patch
Patch3: %name-%version-PerformanceBenchmarking.patch
Patch4: %name-%version-TubeTK.patch

BuildRequires(pre): rpm-build-ubt
BuildRequires: gcc-c++ cmake
BuildRequires: gdcm-devel castxml graphviz libhdf5-devel
BuildRequires: libjpeg-devel libpng-devel libtiff-devel libxml2-devel
BuildRequires: libvxl-devel libvtk-devel zlib-devel
BuildRequires: libblas-devel liblapack-devel libnetcdf-devel jsoncpp-devel
BuildRequires: libexpat-devel dcmtk

BuildRequires: libfftw3-devel libgtest-devel libgmock-devel eigen3-devel
BuildRequires: libminc-devel
BuildRequires: libniftilib-devel
BuildRequires: libXext-devel
BuildRequires: libdouble-conversion-devel

BuildRequires: libnumpy-py3-devel
BuildRequires: liblpsolve-devel

%define _description \
The Insight Toolkit (ITK) is an open-source, cross-platform toolkit for \
N-dimensional scientific image processing, segmentation, and registration. \
Segmentation is the process of identifying and classifying data found in a  \
digitally sampled representation. Typically the sampled representation is an  \
image acquired from such medical instrumentation as CT or MRI scanners. \
Registration is the task of aligning or developing correspondences between \
data. For example, in the medical environment, a CT scan may be aligned with  \
a MRI scan in order to combine the information contained in both.

%description
%_description

%package -n lib%name%itkver
Summary: Shared libraries for ITK
Group: System/Libraries

%description -n lib%name%itkver
This package contains ITK shared libraries.
%_description

%package -n lib%name-devel
Summary: Development files for ITK
Group: Development/C++
Provides: lib%name-glue-devel = %EVR
Conflicts: lib%name-glue-devel < %EVR
Obsoletes: lib%name-glue-devel < %EVR
Requires: lib%name%itkver = %EVR
Requires: lib%name%itkver-glue = %EVR
Requires: %name-testdriver = %EVR
# Following dependencies are duplicates from build dependencies
Requires: libgtest-devel
Requires: libgmock-devel
Requires: eigen3-devel
Requires: gdcm-devel
Requires: libfftw3-devel
Requires: libXext-devel
Requires: libxml2-devel
Requires: libnetcdf-devel
Requires: libvtk-devel
Requires: libvxl-devel

%description -n lib%name-devel
This package contains development files for ITK.
%_description

%package testdriver
Summary: Test driver for ITK
Group: Development/Tools
Requires: lib%name%itkver = %EVR

%description testdriver
This package contains test driver for ITK.
%_description

%package examples
Summary: Examples for ITK
Group: Development/Tools
Requires: lib%name%itkver = %EVR

%description examples
This package contains source code of ITK examples.
%_description

%package doc
Summary: Documentation for ITK
Group: Documentation
BuildArch: noarch

%description doc
This package contains documentation for ITK.
%_description

%package -n lib%name%itkver-glue
Summary: Shared libraries for ITK-VTK bindings
Group: System/Libraries

%description -n lib%name%itkver-glue
This package contains shared libraries for VTK bindings to ITK.
%_description

%prep
%setup -a100 -a101 -a102 -a103 -a104 -a105 -a106 -a107 -a108 -a109 -a110 -a111 -a112 -a113 -a114 -a115 -a116 -a117 -a118 -a119 -a120 -a121 -a122 -a123 -a124 -a125 -a126 -a127 -a128 -a129 -a130 -a131 -a132 -a133 -a134 -a135 -a136 -a137 -a138 -a139 -a140 -a141 -a142
%patch -p1

pushd Modules/Remote/RTK
%patch1 -p1
popd

pushd Modules/Remote/VariationalRegistration
%patch2 -p1
popd

pushd Modules/Remote/PerformanceBenchmarking
%patch3 -p1
popd

pushd Modules/Remote/TubeTK
%patch4 -p1
popd

# Save an unbuilt copy of the Example's sources for %%doc
mkdir itk-examples
cp -a Examples itk-examples

# Delete unused third party sources
rm -rf Modules/ThirdParty/Expat/src/
rm -rf Modules/ThirdParty/GDCM/src/
rm -rf Modules/ThirdParty/MINC/src/libminc/
rm -rf Modules/ThirdParty/MINC/src/CMakeLists.txt
rm -rf Modules/ThirdParty/HDF5/src/itkhdf5/
rm -rf Modules/ThirdParty/HDF5/src/CMakeLists.txt
rm -rf Modules/ThirdParty/HDF5/src/README.md
rm -rf Modules/ThirdParty/JPEG/src/itkjpeg/
rm -rf Modules/ThirdParty/JPEG/src/CMakeLists.txt
rm -rf Modules/ThirdParty/PNG/src/itkpng/
rm -rf Modules/ThirdParty/PNG/src/CMakeLists.txt
rm -rf Modules/ThirdParty/TIFF/src/itktiff/
rm -rf Modules/ThirdParty/TIFF/src/CMakeLists.txt
rm -rf Modules/ThirdParty/ZLIB/src/itkzlib/
rm -rf Modules/ThirdParty/ZLIB/src/CMakeLists.txt
rm -rf Modules/ThirdParty/VNL/src/
rm -rf Modules/ThirdParty/DoubleConversion/src
rm -rf Modules/ThirdParty/GoogleTest/src

%build
%ifarch aarch64 ppc64le
# limit build jobs on aarch64 and ppc64le to prevent resources exhaustion
if [ %__nprocs -gt 8 ] ; then
	export NPROCS=8
fi
%endif

# XXX: itk-examples (ex-Examples) for some reason are linked with the build
# artifact dir in the runpath, so we pass -DCMAKE_SKIP_RPATH=ON.
# remote modules go last
%cmake \
%qIF_ver_lt %ubt_id S1
       -DPYTHON_EXECUTABLE=%__python3 \
%endif
       %_cmake_skip_rpath \
       -DCMAKE_BUILD_TYPE:STRING="RelWithDebInfo" \
       -DCMAKE_VERBOSE_MAKEFILE=ON \
       -DCMAKE_CXX_FLAGS:STRING="-std=gnu++11 %{optflags}" \
       -DBUILD_SHARED_LIBS:BOOL=ON \
       -DBUILD_TESTING=OFF \
       -DBUILD_EXAMPLES:BOOL=ON \
       -DBUILD_DOCUMENTATION:BOOL=OFF \
       -DITK_BUILD_DEFAULT_MODULES:BOOL=ON \
       -DITK_WRAP_PYTHON:BOOL=OFF \
       -DITK_WRAP_JAVA:BOOL=OFF \
       -DITK_INSTALL_LIBRARY_DIR=%_lib/ \
       -DITK_INSTALL_INCLUDE_DIR=include/%name \
       -DITK_INSTALL_PACKAGE_DIR=%_lib/cmake/%name/ \
       -DITK_INSTALL_RUNTIME_DIR:PATH=%_bindir \
       -DITK_INSTALL_DOC_DIR=share/doc/%name/ \
       -DITK_USE_KWSTYLE:BOOL=OFF \
       -DITK_FORBID_DOWNLOADS=ON \
       -DModule_ITKReview:BOOL=ON \
       -DITK_USE_SYSTEM_LIBRARIES:BOOL=ON \
       -DITK_USE_FFTWD=ON \
       -DITK_USE_FFTWF=ON \
       -DITK_USE_SYSTEM_DCMTK=ON \
       -DITK_USE_SYSTEM_EXPAT=ON \
       -DITK_USE_SYSTEM_FFTW=ON \
       -DITK_USE_SYSTEM_GDCM=ON \
       -DITK_USE_SYSTEM_MINC=ON \
       -DITK_USE_SYSTEM_HDF5=ON \
       -DITK_USE_SYSTEM_JPEG=ON \
       -DITK_USE_SYSTEM_PNG=ON \
       -DITK_USE_SYSTEM_TIFF=ON \
       -DITK_USE_SYSTEM_ZLIB=ON \
       -DITK_USE_SYSTEM_VXL=ON \
       -DITK_USE_SYSTEM_DOUBLECONVERSION=ON \
       -DModule_ITKVtkGlue:BOOL=ON \
       -DModule_ITKIOPNG:BOOL=ON \
       -DModule_ITKDCMTK:BOOL=ON \
       -DModule_ITKIODCMTK:BOOL=ON \
       -DITKV4_COMPATIBILITY:BOOL=ON \
       -DModule_ITKDeprecated:BOOL=ON \
       -DRTK_INSTALL_NO_EXECUTABLES:BOOL=ON \
	-DModule_AnalyzeObjectLabelMap:BOOL=ON \
	-DModule_AnalyzeObjectLabelMap_BUILD_EXAMPLES:BOOL=OFF \
	-DModule_AnisotropicDiffusionLBR:BOOL=ON \
	-DModule_AnisotropicDiffusionLBR_BUILD_EXAMPLES:BOOL=OFF \
	-DModule_BioCell:BOOL=ON \
	-DModule_BioCell_BUILD_EXAMPLES:BOOL=OFF \
	-DModule_BoneEnhancement:BOOL=ON \
	-DModule_BoneEnhancement_BUILD_EXAMPLES:BOOL=OFF \
	-DModule_BoneMorphometry:BOOL=ON \
	-DModule_BoneMorphometry_BUILD_EXAMPLES:BOOL=OFF \
	-DModule_BSplineGradient:BOOL=ON \
	-DModule_BSplineGradient_BUILD_EXAMPLES:BOOL=OFF \
	-DModule_Cuberille:BOOL=ON \
	-DModule_Cuberille_BUILD_EXAMPLES:BOOL=OFF \
	-DModule_NeuralNetworks:BOOL=ON \
	-DModule_NeuralNetworks_BUILD_EXAMPLES:BOOL=OFF \
	-DModule_FixedPointInverseDisplacementField:BOOL=ON \
	-DModule_FixedPointInverseDisplacementField_BUILD_EXAMPLES:BOOL=OFF \
	-DModule_GenericLabelInterpolator:BOOL=ON \
	-DModule_GenericLabelInterpolator_BUILD_EXAMPLES:BOOL=OFF \
	-DModule_HigherOrderAccurateGradient:BOOL=ON \
	-DModule_HigherOrderAccurateGradient_BUILD_EXAMPLES:BOOL=OFF \
	-DModule_IOFDF:BOOL=ON \
	-DModule_IOFDF_BUILD_EXAMPLES:BOOL=OFF \
	-DModule_IOMeshSTL:BOOL=ON \
	-DModule_IOMeshSTL_BUILD_EXAMPLES:BOOL=OFF \
	-DModule_IOOpenSlide:BOOL=ON \
	-DModule_IOOpenSlide_BUILD_EXAMPLES:BOOL=OFF \
	-DModule_IOScanco:BOOL=ON \
	-DModule_IOScanco_BUILD_EXAMPLES:BOOL=OFF \
	-DModule_IOTransformDCMTK:BOOL=ON \
	-DModule_IOTransformDCMTK_BUILD_EXAMPLES:BOOL=OFF \
	-DModule_IsotropicWavelets:BOOL=ON \
	-DModule_IsotropicWavelets_BUILD_EXAMPLES:BOOL=OFF \
	-DModule_LabelErodeDilate:BOOL=ON \
	-DModule_LabelErodeDilate_BUILD_EXAMPLES:BOOL=OFF \
	-DModule_LesionSizingToolkit:BOOL=ON \
	-DModule_LesionSizingToolkit_BUILD_EXAMPLES:BOOL=OFF \
	-DModule_MeshNoise:BOOL=ON \
	-DModule_MeshNoise_BUILD_EXAMPLES:BOOL=OFF \
	-DModule_MGHIO:BOOL=ON \
	-DModule_MGHIO_BUILD_EXAMPLES:BOOL=OFF \
	-DModule_MinimalPathExtraction:BOOL=ON \
	-DModule_MinimalPathExtraction_BUILD_EXAMPLES:BOOL=OFF \
	-DModule_Montage:BOOL=ON \
	-DModule_Montage_BUILD_EXAMPLES:BOOL=OFF \
	-DModule_MorphologicalContourInterpolation:BOOL=ON \
	-DModule_MorphologicalContourInterpolation_BUILD_EXAMPLES:BOOL=OFF \
	-DModule_MultipleImageIterator:BOOL=ON \
	-DModule_MultipleImageIterator_BUILD_EXAMPLES:BOOL=OFF \
	-DModule_ParabolicMorphology:BOOL=ON \
	-DModule_ParabolicMorphology_BUILD_EXAMPLES:BOOL=OFF \
	-DModule_PerformanceBenchmarking:BOOL=ON \
	-DModule_PerformanceBenchmarking_BUILD_EXAMPLES:BOOL=OFF \
	-DModule_PhaseSymmetry:BOOL=ON \
	-DModule_PhaseSymmetry_BUILD_EXAMPLES:BOOL=OFF \
	-DModule_PolarTransform:BOOL=ON \
	-DModule_PolarTransform_BUILD_EXAMPLES:BOOL=OFF \
	-DModule_PrincipalComponentsAnalysis:BOOL=ON \
	-DModule_PrincipalComponentsAnalysis_BUILD_EXAMPLES:BOOL=OFF \
	-DModule_RLEImage:BOOL=ON \
	-DModule_RLEImage_BUILD_EXAMPLES:BOOL=OFF \
	-DModule_RTK:BOOL=ON \
	-DModule_RTK_BUILD_EXAMPLES:BOOL=OFF \
	-DModule_SimpleITKFilters:BOOL=ON \
	-DModule_SimpleITKFilters_BUILD_EXAMPLES:BOOL=OFF \
	-DModule_SkullStrip:BOOL=ON \
	-DModule_SkullStrip_BUILD_EXAMPLES:BOOL=OFF \
	-DModule_SmoothingRecursiveYvvGaussianFilter:BOOL=ON \
	-DModule_SmoothingRecursiveYvvGaussianFilter_BUILD_EXAMPLES:BOOL=OFF \
	-DModule_SplitComponents:BOOL=ON \
	-DModule_SplitComponents_BUILD_EXAMPLES:BOOL=OFF \
	-DModule_Strain:BOOL=ON \
	-DModule_Strain_BUILD_EXAMPLES:BOOL=OFF \
	-DModule_SubdivisionQuadEdgeMeshFilter:BOOL=ON \
	-DModule_SubdivisionQuadEdgeMeshFilter_BUILD_EXAMPLES:BOOL=OFF \
	-DModule_TextureFeatures:BOOL=ON \
	-DModule_TextureFeatures_BUILD_EXAMPLES:BOOL=OFF \
	-DModule_Thickness3D:BOOL=ON \
	-DModule_Thickness3D_BUILD_EXAMPLES:BOOL=OFF \
	-DModule_TubeTK:BOOL=ON \
	-DModule_TubeTK_BUILD_EXAMPLES:BOOL=OFF \
	-DModule_TwoProjectionRegistration:BOOL=ON \
	-DModule_TwoProjectionRegistration_BUILD_EXAMPLES:BOOL=OFF \
	-DModule_VariationalRegistration:BOOL=ON \
	-DModule_VariationalRegistration_BUILD_EXAMPLES:BOOL=OFF \
    %nil

%cmake_build

%install
%qIF_ver_lt %ubt_id S1
%cmakeinstall_std
%else
%cmake_install
%endif

# Don't install test driver as example
rm -f %_cmake__builddir/bin/itkTestDriver

install -D -m755 -t %buildroot%_libdir/%name-examples/ %_cmake__builddir/bin/*

%files -n lib%name%itkver
%_libdir/lib*-%itkver.so.*
%exclude %_libdir/libITKVtkGlue-%itkver.so.*

%files -n lib%name-devel
%_libdir/lib*-%itkver.so
%_includedir/%name/
%_libdir/cmake/*

%files testdriver
%_bindir/itkTestDriver

%files examples
%doc itk-examples/Examples/
%_libdir/%name-examples/

%files doc
%doc %_docdir/%name/

%files -n lib%name%itkver-glue
%_libdir/libITKVtkGlue-%itkver.so.*

%changelog
