Group: Development/Other
# BEGIN SourceDeps(oneline):
BuildRequires(pre): rpm-macros-java
BuildRequires: unzip
# END SourceDeps(oneline)
BuildRequires: /proc rpm-build-java
BuildRequires: jpackage-11-compat
%define fedora 33
# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}
Name:		java-sleep
Version:	2.1
Release:	alt1_21jpp11
Summary:	Multi-paradigm scripting language for Java

License:	LGPLv2+ and BSD
URL:		http://sleep.dashnine.org/
Source0:	http://sleep.dashnine.org/download/sleep21-bsd.zip
# Patch to allow bootstrapping sleep.jar without sleep-engine.jar
Patch0:		sleep-bootstrap.patch
# Bump target version to 1.6 for JDF 11 support
Patch1:         sleep-target.patch
# Fix docs target
Patch2:         java-sleep-docs.patch
BuildArch:	noarch

BuildRequires:	jpackage-utils
BuildRequires:	ant-contrib
Requires:	jpackage-utils
%if 0%{?fedora} || 0%{?rhel} >= 7
%else
Requires:	java
%endif
Source44: import.info

%description
Sleep ...

 - is a multi-paradigm scripting language for the Java Platform
 - easy to learn with Perl and Objective-C inspired syntax
 - executes scripts fast with a small package size (~250KB)
 - excels at data manipulation, component integration, and distributed
   communication
 - seamlessly uses Java objects and 3rd party libraries


%package javadoc
Group: Development/Java
Summary:	Javadocs for %{name}
Requires:	jpackage-utils
BuildArch: noarch

%description javadoc
This package contains the API documentation for %{name}.


%prep
%setup -q -n sleep-master
%patch0 -p1 -b .bootstrap
%patch1 -p1 -b .target
%patch2 -p1 -b .docs
find -name \*.jar -delete
sed -i -e 's/\r//' *.txt
# Fix FSF address
sed -i -e 's/59 Temple Place, Suite 330/51 Franklin Street, Fifth Floor/' \
       -e 's/MA  02111-1307/MA  02110-1301/' license.txt


%build
# Build without sleep-engine components
ant -Dant.build.javac.source=1.8 -Dant.build.javac.target=1.8  -Dbootstrap=true
# Build sleep-engine.jar
ant -Dant.build.javac.source=1.8 -Dant.build.javac.target=1.8  -f jsr223/build.xml
# Build in the sleep-engine components
ant -Dant.build.javac.source=1.8 -Dant.build.javac.target=1.8 
# Build the test data jars
ant -Dant.build.javac.source=1.8 -Dant.build.javac.target=1.8  -f tests/data/build.xml
ant -Dant.build.javac.source=1.8 -Dant.build.javac.target=1.8  -f tests/data2/build.xml
ant -Dant.build.javac.source=1.8 -Dant.build.javac.target=1.8  -f tests/data3/build.xml
# Build docs
ant -Dant.build.javac.source=1.8 -Dant.build.javac.target=1.8  docs


%install
mkdir -p $RPM_BUILD_ROOT%{_javadir}
cp -p sleep.jar $RPM_BUILD_ROOT%{_javadir}/%{name}.jar
ln -s %{name}.jar $RPM_BUILD_ROOT%{_javadir}/sleep.jar
mkdir -p $RPM_BUILD_ROOT%{_javadocdir}/%{name}
mv docs/api docs_api
cp -rp docs_api $RPM_BUILD_ROOT%{_javadocdir}/%{name}/api


%check
java -jar sleep.jar runtests.sl


%files
%doc *.txt docs
%{_javadir}/%{name}.jar
%{_javadir}/sleep.jar


%files javadoc
%{_javadocdir}/%{name}


%changelog
