%def_disable static
%def_disable docs

Name: jq
%define lname lib%name
Version: 1.7.1
Release: alt1
Summary: Command-line JSON processor
Group: Development/Other
Source: %name-%version.tar
Patch0: %name-%version-alt.patch
Url: https://stedolan.github.io/jq/
VCS: https://github.com/stedolan/jq
License: BSD
Requires: %lname = %EVR

BuildRequires: flex  liboniguruma-devel
%{?!_disable_check:BuildRequires: /proc valgrind ruby-tools}

%description
%name is a command-line JSON processor.

%package -n %lname
Summary: %name shared library
Group: System/Libraries

%description -n %lname
%name shared library.

%package -n %lname-devel
Summary: Files for devel with %name library
Group: Development/C
Requires: %lname = %EVR

%description -n %lname-devel
Files for devel with %name library.

%if_enabled static
%package -n %lname-devel-static
Summary: %name static library
Group: Development/C
Requires: %lname-devel = %version-%release

%description -n %lname-devel-static
%name static library.
%endif

%prep
%setup
%patch0 -p1
rm scripts/version
printf "#!/bin/sh\necho %version\n" > scripts/version
chmod +x scripts/version

%build
%autoreconf
./configure \
	--prefix=%_prefix \
	--libdir=%_libdir \
	--enable-shared \
	#
%make_build V=1

%install
%makeinstall_std docdir=%_docdir/%name-%version
ln -sf README.md %buildroot%_docdir/%name-%version/README

%check
export LD_LIBRARY_PATH=$PWD/.libs
%make_build check || :
cat ./test-suite.log

%files
%doc %_docdir/%name-%version
%_bindir/*
%_man1dir/*

%files -n %lname
%_libdir/*.so.*

%files -n %lname-devel
%_includedir/*
%_libdir/*.so
%_pkgconfigdir/libjq.pc

%if_enabled static
%files -n %lname-devel-static
%_libdir/*.a
%endif

%changelog
