%define _unpackaged_files_terminate_build 1
%define java_home %_jvmdir/jre

%def_with check

%define nss_version 3.66
%define java_version 11

Name: jss
Version: 4.9.5
Release: alt1.p10.3

Summary: Java Security Services (JSS)
License: MPL-1.1 or GPLv2+ or LGPLv2+
Group: System/Libraries
# Source-git: https://github.com/dogtagpki/jss.git
Url: http://www.dogtagpki.org/wiki/JSS

Source0: %name-%version.tar
Source1: jss.watch
Patch: %name-%version-alt.patch

BuildRequires(pre): rpm-macros-java
BuildRequires(pre): rpm-macros-cmake
BuildRequires: gcc-c++
BuildRequires: jaxb-api
BuildRequires: /proc
BuildRequires: cmake
BuildRequires: java-11-devel >= %java_version
BuildRequires: jpackage-11-compat
BuildRequires: libnss-devel >= %nss_version
BuildRequires: libnspr-devel
BuildRequires: apache-commons-lang3
BuildRequires: slf4j
BuildRequires: slf4j-jdk14

# deps for tools/reproducible_jar.sh
BuildRequires: zip
BuildRequires: unzip

# not an optional though used only in tests
BuildRequires: junit

%if_with check
BuildRequires: ctest
BuildRequires: nss-utils >= %nss_version
%endif

Requires: apache-commons-lang3
Requires: jaxb-api
Requires: slf4j
Requires: libnss >= %nss_version
Requires: java >= %java_version

%description
Network Security Services for Java (JSS) is a Java interface to NSS. JSS
supports most of the security standards and encryption technologies supported by
NSS. JSS also provides a pure Java interface for ASN.1 types and BER/DER
encoding.

JSS offers a implementation of Java SSL sockets that uses NSS's SSL/TLS
implementation rather than Sun's JSSE implementation. You might want to use
JSS's own SSL classes if you want to use some of the capabilities found in NSS's
SSL/TLS library but not found in JSSE.

NSS is the cryptographic module where all cryptographic operations are
performed. JSS essentially provides a Java JNI bridge to NSS C shared libraries.
When NSS is put in FIPS mode, JSS ensures FIPS compliance by ensuring that all
cryptographic operations are performed by the NSS cryptographic module.

%package javadoc
Summary: Java Security Services (JSS) Javadocs
Group: Development/Java
Requires: %name = %EVR
BuildArch: noarch

%description javadoc
This package contains the API documentation for JSS.

%prep
%setup
%patch -p1

%build
# Enable compiler optimizations and disable debugging code
# NOTE: If you ever need to create a debug build with optimizations disabled
# just comment out this line and change in the %%install section below the
# line that copies jars xpclass.jar to be xpclass_dbg.jar
export BUILD_OPT=1

%cmake \
    -DJAVA_HOME=%java_home \
    -DVERSION=%version \
    -DJAVA_LIB_INSTALL_DIR=%_jnidir \
    -DJSS_LIB_INSTALL_DIR=%_libdir/jss \
    ..

%cmake_build --target all javadoc

%check
# fails on migration to Java11, need to investigate
%ifnarch ppc64le
# FIPS is not enabled in kernel
cat > %_cmake__builddir/CTestCustom.cmake <<EOF
set(CTEST_CUSTOM_TESTS_IGNORE
   Enable_FipsMODE
)
EOF
#CTEST_OUTPUT_ON_FAILURE=1 %cmake_build --target test
%endif

%install
%cmake_install

%files
%dir %_libdir/jss
%_libdir/jss/jss4.jar
%_libdir/jss/jss.jar
%_libdir/jss/libjss4.so
%_libdir/jss/libjss.so
%_jnidir/jss4.jar
%_jnidir/jss.jar

%files javadoc
%_javadocdir/%name-%version

%changelog
