%define rname messagelib

%ifarch %not_qt5_qtwebengine_arches
%def_disable qtwebengine
%else
%def_enable qtwebengine
%endif

%define sover 5
%define libkf5messagecomposer libkf5messagecomposer%sover
%define libkf5messagecore libkf5messagecore%sover
%define libkf5messageviewer libkf5messageviewer%sover
%define libkf5messagelist libkf5messagelist%sover
%define libkf5messageparser libkf5messageparser%sover
%define libkf5mimetreeparser libkf5mimetreeparser%sover
%define libkf5webengineviewer libkf5webengineviewer%sover

Name: kde5-%rname
Version: 23.08.5
Release: alt1
%K5init

Group: System/Libraries
Summary: KDE5 %rname library
Url: http://www.kde.org
License: GPLv2+ / LGPLv2+

Source: %rname-%version.tar
Patch1: alt-gpgme17.patch

# Automatically added by buildreq on Thu Apr 28 2016 (-bi)
# optimized out: boost-devel-headers cmake cmake-modules elfutils gcc-c++ glibc-devel-static kde5-akonadi-devel kf5-kdelibs4support kf5-kdoctools kf5-kdoctools-devel libEGL-devel libGL-devel libdbusmenu-qt52 libgpg-error libgpg-error-devel libgst-plugins1.0 libical-devel libjson-c libkf5gpgmepp-pthread libqt5-core libqt5-dbus libqt5-gui libqt5-network libqt5-opengl libqt5-positioning libqt5-printsupport libqt5-qml libqt5-quick libqt5-script libqt5-sensors libqt5-sql libqt5-svg libqt5-test libqt5-webchannel libqt5-webkit libqt5-webkitwidgets libqt5-widgets libqt5-x11extras libqt5-xml libsasl2-3 libstdc++-devel libxcbutil-keysyms perl pkg-config python-base python-modules python3 python3-base qt5-base-devel qt5-tools-devel qt5-webkit-devel rpm-build-python3 ruby ruby-stdlibs
#BuildRequires: extra-cmake-modules grantlee5-devel kde5-akonadi-search-devel kde5-gpgmepp-devel kde5-grantleetheme-devel kde5-kcalcore-devel kde5-kcontacts-devel kde5-kidentitymanagement-devel kde5-kimap-devel kde5-kldap-devel kde5-kmailtransport-devel kde5-kmbox-devel kde5-kmime-devel kde5-kpimtextedit-devel kde5-libgravatar-devel kde5-libkdepim-devel kde5-libkleo-devel  kde5-pimcommon-devel kde5-pimlibs-devel kf5-karchive-devel kf5-kauth-devel kf5-kbookmarks-devel kf5-kcodecs-devel kf5-kcompletion-devel kf5-kconfig-devel kf5-kconfigwidgets-devel kf5-kcoreaddons-devel kf5-kcrash-devel kf5-kdbusaddons-devel kf5-kdelibs4support-devel kf5-kdesignerplugin-devel kf5-kdoctools-devel kf5-kemoticons-devel kf5-kguiaddons-devel kf5-ki18n-devel kf5-kiconthemes-devel kf5-kinit-devel kf5-kio-devel kf5-kitemmodels-devel kf5-kitemviews-devel kf5-kjobwidgets-devel kf5-knotifications-devel kf5-kparts-devel kf5-kservice-devel kf5-ktextwidgets-devel kf5-kunitconversion-devel kf5-kwallet-devel kf5-kwidgetsaddons-devel kf5-kwindowsystem-devel kf5-kxmlgui-devel kf5-solid-devel kf5-sonnet-devel libgpgme-devel libldap-devel libsasl2-devel python-module-google python3-dev qt5-tools-devel-static rpm-build-ruby
BuildRequires(pre): rpm-build-kf5 rpm-macros-qt5-webengine
BuildRequires: extra-cmake-modules qt5-tools-devel-static
%if_enabled qtwebengine
BuildRequires: qt5-webengine-devel
%endif
BuildRequires: grantlee5-devel libqca-qt5-devel
BuildRequires: libgpgme-devel libassuan-devel libldap-devel libsasl2-devel
BuildRequires: kde5-ktextaddons-devel
BuildRequires: kde5-akonadi-search-devel kde5-grantleetheme-devel kde5-kcalcore-devel kde5-kcontacts-devel
BuildRequires: kde5-kidentitymanagement-devel kde5-kimap-devel kde5-kldap-devel kde5-kmailtransport-devel kde5-kmbox-devel
BuildRequires: kde5-kmime-devel kde5-kpimtextedit-devel kde5-libgravatar-devel kde5-libkdepim-devel kde5-libkleo-devel
BuildRequires:  kde5-pimcommon-devel
BuildRequires: boost-devel kde5-akonadi-devel kde5-akonadi-mime-devel kde5-akonadi-contacts-devel kde5-akonadi-notes-devel
BuildRequires: kf5-karchive-devel kf5-kauth-devel kf5-kbookmarks-devel kf5-kcodecs-devel kf5-kcompletion-devel kf5-kconfig-devel
BuildRequires: kf5-kconfigwidgets-devel kf5-kcoreaddons-devel kf5-kcrash-devel kf5-kdbusaddons-devel kf5-kdelibs4support-devel
BuildRequires: kf5-kdesignerplugin-devel kf5-kdoctools-devel kf5-kemoticons-devel kf5-kguiaddons-devel
BuildRequires: kf5-ki18n-devel kf5-kiconthemes-devel kf5-kinit-devel kf5-kio-devel kf5-kitemmodels-devel kf5-kitemviews-devel
BuildRequires: kf5-kjobwidgets-devel kf5-knotifications-devel kf5-kparts-devel kf5-kservice-devel kf5-ktextwidgets-devel
BuildRequires: kf5-kunitconversion-devel kf5-kwallet-devel kf5-kwidgetsaddons-devel kf5-kwindowsystem-devel kf5-kxmlgui-devel
BuildRequires: kf5-solid-devel kf5-sonnet-devel kf5-syntax-highlighting-devel kf5-knewstuff-devel

%description
%summary.

%package common
Summary: %name common package
Group: System/Configuration/Other
#BuildArch: noarch
Requires: kf5-filesystem
%description common
%name common package

%package devel
Group: Development/KDE and QT
Summary: Development files for %name
%if_enabled qtwebengine
Requires: qt5-webengine-devel
%endif
%description devel
The %name-devel package contains libraries and header files for
developing applications that use %name.

%package -n %libkf5messagecomposer
Group: System/Libraries
Summary: KF5 library
Requires: %name-common = %version-%release
%description -n %libkf5messagecomposer
KF5 library

%package -n %libkf5messagecore
Group: System/Libraries
Summary: KF5 library
Requires: %name-common = %version-%release
%description -n %libkf5messagecore
KF5 library

%package -n %libkf5messageviewer
Group: System/Libraries
Summary: KF5 library
Requires: %name-common = %version-%release
%description -n %libkf5messageviewer
KF5 library

%package -n %libkf5messagelist
Group: System/Libraries
Summary: KF5 library
Requires: %name-common = %version-%release
%description -n %libkf5messagelist
KF5 library

%package -n %libkf5messageparser
Group: System/Libraries
Summary: KF5 library
Requires: %name-common = %version-%release
%description -n %libkf5messageparser
KF5 library

%package -n %libkf5mimetreeparser
Group: System/Libraries
Summary: KF5 library
Requires: %name-common = %version-%release
%description -n %libkf5mimetreeparser
KF5 library

%package -n %libkf5webengineviewer
Group: System/Libraries
Summary: KF5 library
Requires: %name-common = %version-%release
%description -n %libkf5webengineviewer
KF5 library

%prep
%setup -n %rname-%version
#%patch1 -p1

%if_disabled qtwebengine
sed -i 's|WebEngineWidgets||' CMakeLists.txt
sed -i 's|WebEngine||' CMakeLists.txt
for subd in \
    messageviewer \
    webengineviewer \
    templateparser \
    messagecomposer \
    #
do
    rs=`basename ${subd}`
    dir=`dirname ${subd}`
    sed -i "/add_subdirectory(${rs})/d" ./${dir}/CMakeLists.txt
    rm -rf ./$subd
done
%endif

%build
%K5build \
    -DDATA_INSTALL_DIR=%_K5data \
    -DQGpgme_DIR=%_libdir/cmake/Gpgmepp/ \
    #

%install
%K5install
%K5install_move data libmessageviewer messagelist messageviewer kconf_update
%K5install_move data org.kde.syntax-highlighting knsrcfiles
%find_lang %name --with-kde --all-name

mkdir -p %buildroot/%_K5plug/pim5

%files common -f %name.lang
%doc LICENSES/*
%dir %_K5plug/pim5/
%_datadir/qlogging-categories5/*.*categories
%_K5data/messagelist/

%files devel
%_includedir/KPim5/*
%_K5link/lib*.so
%_K5lib/cmake/*/
%_K5archdata/mkspecs/modules/qt_*.pri

%if_enabled qtwebengine
%files -n %libkf5messagecomposer
%_K5lib/libKPim5MessageComposer.so.%sover
%_K5lib/libKPim5MessageComposer.so.*
%files -n %libkf5webengineviewer
%_K5lib/libKPim5WebEngineViewer.so.%sover
%_K5lib/libKPim5WebEngineViewer.so.*
%files -n %libkf5messageviewer
%_K5lib/libKPim5MessageViewer.so.%sover
%_K5lib/libKPim5MessageViewer.so.*
%dir %_K5plug/pim5/messageviewer/
%dir %_K5plug/pim5/messageviewer/headerstyle/
%_K5plug/pim5/messageviewer/headerstyle/*.so
%_K5plug/pim5/messageviewer/grantlee/
%_K5data/knsrcfiles/
%_K5data/libmessageviewer/
%_K5data/messageviewer/
%_K5notif/*.notifyrc
%files -n %libkf5messageparser
%_K5lib/libKPim5TemplateParser.so.%sover
%_K5lib/libKPim5TemplateParser.so.*
%_K5data/org.kde.syntax-highlighting/
%_K5cfg/*template*.kcfg
%endif

%files -n %libkf5messagecore
%_K5lib/libKPim5MessageCore.so.%sover
%_K5lib/libKPim5MessageCore.so.*
%files -n %libkf5messagelist
%_K5lib/libKPim5MessageList.so.%sover
%_K5lib/libKPim5MessageList.so.*
%files -n %libkf5mimetreeparser
%_K5lib/libKPim5MimeTreeParser.so.%sover
%_K5lib/libKPim5MimeTreeParser.so.*

%changelog
