%define module_name	bcmwl
%define module_version	6.30.223.271
%define module_release alt15

%define flavour		un-def
%define karch x86_64
BuildRequires(pre): rpm-build-kernel
BuildRequires(pre): kernel-headers-modules-un-def

%setup_kernel_module %flavour

%define norm_version	%kversion

%define module_dir /lib/modules/%kversion-%flavour-%krelease/net

Summary: Modules for Broadcom IEEE 802.11a/b/g/n adapters
Name: kernel-modules-%module_name-%flavour
Version: %module_version
Release: %module_release.%kcode.%kbuildrelease
License: Proprietary
Group: System/Kernel and hardware

Packager: Kernel Maintainer Team <kernel@packages.altlinux.org>

ExclusiveOS: Linux
Url: https://github.com/antoineco/broadcom-wl
BuildRequires: perl sharutils
BuildRequires(pre): rpm-build-kernel
BuildRequires: kernel-source-%module_name = %module_version
BuildRequires: kernel-headers-modules-%flavour = %kepoch%kversion-%krelease

Provides: kernel-modules-%module_name-%kversion-%flavour-%krelease = %version-%release
Conflicts: kernel-modules-%module_name-%kversion-%flavour-%krelease < %version-%release
Conflicts: kernel-modules-%module_name-%kversion-%flavour-%krelease > %version-%release

PreReq: kernel-image-%flavour = %kepoch%kversion-%krelease
ExclusiveArch: %karch

Patch: %{module_name}-centos9.patch

%description
These packages contain Broadcom's IEEE 802.11a/b/g/n hybrid Linux device
driver for use with Broadcom's BCM4311-, BCM4312-, BCM4313-, BCM4321-,
BCM4322-, BCM43224-, and BCM43225-, BCM43227- and BCM43228-based hardware

NOTE: You must read the LICENSE.TXT file in the lib directory before
using this software.
%prep
rm -rf kernel-source-%module_name-%module_version

tar -jxvf %kernel_src/kernel-source-%module_name-%module_version.tar.bz2

%setup -D -T -n kernel-source-%module_name-%module_version

# centos backported some fixes for 5.17+
if [ %flavour == "centos" ]; then
%patch -p1
fi

%build
cd bcmwl
. %_usrsrc/linux-%kversion-%flavour/gcc_version.inc
make -C %_usrsrc/linux-%kversion-%flavour M=`pwd` modules

%install
mkdir -p $RPM_BUILD_ROOT%module_dir/

cd bcmwl
. %_usrsrc/linux-%kversion-%flavour/gcc_version.inc
make -C %_usrsrc/linux-%kversion-%flavour INSTALL_MOD_PATH=%buildroot INSTALL_MOD_DIR=net M=`pwd`  modules_install

%files
%module_dir

%changelog
