%define module_name             ixgbe
%define module_version          5.20.10
%define module_release          alt1

%define flavour un-def
%define karch x86_64 aarch64 ppc64le

BuildRequires(pre): rpm-build-kernel
BuildRequires(pre): kernel-headers-modules-un-def

%setup_kernel_module %flavour

%define module_dir /lib/modules/%kversion-%flavour-%krelease/updates
%add_verify_elf_skiplist %module_dir/*

Name: kernel-modules-%module_name-%flavour
Version: %module_version
Release: %module_release.%kcode.%kbuildrelease

Summary: Intel(R) 10GbE PCI Express Linux Network Driver
License: GPL-2.0-only
Group: System/Kernel and hardware
Url: http://www.intel.com/network/connectivity/products/server_adapters.htm

Packager: Kernel Maintainer Team <kernel@packages.altlinux.org>

ExclusiveOS: Linux
BuildRequires(pre): rpm-build-kernel /proc
BuildRequires: kernel-headers-modules-%flavour = %kepoch%kversion-%krelease
BuildRequires: kernel-source-%module_name

Patch1: allow-all-sfp.patch
Patch2: fix-build-6.1.43.patch

Provides: kernel-modules-%module_name-%kversion-%flavour-%krelease = %version-%release
Conflicts: kernel-modules-%module_name-%kversion-%flavour-%krelease < %version-%release
Conflicts: kernel-modules-%module_name-%kversion-%flavour-%krelease > %version-%release

# Due to /etc/modprobe.d/blacklist-ixgbe.conf
Conflicts: kernel-modules-ixgbe-std-def < 5.12.5-alt2
Conflicts: kernel-modules-ixgbe-un-def < 5.12.5-alt2

Requires(pre): kernel-image-%flavour = %kepoch%kversion-%krelease
ExclusiveArch: %karch

%description
%module_name contains the Intel(R) 10GbE PCI Express Linux Network Driver.

%prep
rm -rf %module_name-%module_version
tar -jxvf %kernel_src/kernel-source-%module_name-%module_version.tar.bz2
%setup -D -T -n kernel-source-%module_name-%module_version
%patch1 -p1
%patch2 -p1

%build
pushd src
. %_usrsrc/linux-%kversion-%flavour/gcc_version.inc
%make_build KSRC=%_usrsrc/linux-%kversion-%flavour
popd

%install
install -Dp -m600 src/%module_name.ko %buildroot/%module_dir/%module_name.ko

# Warning about the conflicted module version
%triggerpostun -- kernel-modules-ixgbe-std-def < 5.12.5-alt2
if [ "$2" -gt 0 ]; then
        echo "Warning! Conflicted ixgbe module for std-def kernel flavor removed."
        echo "Do not forget to manually install ixgbe kernel modules for all the needed kernel flavours if you need them."
fi

%triggerpostun -- kernel-modules-ixgbe-un-def < 5.12.5-alt2
if [ "$2" -gt 0 ]; then
        echo "Warning! Conflicted ixgbe module for un-def kernel flavor removed."
        echo "Do not forget to manually install ixgbe kernel modules for all the needed kernel flavours if you need them."
fi

%files
%module_dir/*

%changelog
