%define module_name	r8168
%define module_release	alt1.k
%define module_version	8.053.01

%define flavour		un-def
%define karch %ix86 x86_64 aarch64 ppc64le armh

%setup_kernel_module %flavour

%define module_dir /lib/modules/%kversion-%flavour-%krelease/kernel/drivers/net

Name: kernel-modules-%module_name-%flavour
Version: %module_version
Release: %module_release.%kcode.%kbuildrelease

Summary: Linux driver for RealTek Ethernet controllers
License: GPLv2+
Group: System/Kernel and hardware

URL: http://www.realtek.com/
Packager: Kernel Maintainer Team <kernel@packages.altlinux.org>

ExclusiveOS: Linux
ExclusiveArch: %karch

BuildRequires(pre): rpm-build-kernel
BuildRequires(pre): kernel-headers-modules-un-def

BuildRequires: module-init-tools
BuildRequires: kernel-headers-modules-%flavour = %kepoch%kversion-%krelease
BuildRequires: kernel-source-%module_name = %module_version

Requires(pre): kernel-image-%flavour = %kepoch%kversion-%krelease

Requires: r8168-blacklist
 
Provides:  kernel-modules-%module_name-%kversion-%flavour-%krelease = %version-%release kernel-modules-rtl8168-%flavour
Obsoletes: kernel-modules-rtl8168-%flavour
Conflicts: kernel-modules-rtl8168-%flavour

%description
RTL8168 is the Linux device driver released for RealTek RTL8168B/8111B,
RTL8168C/8111C, RTL8168CP/8111CP, RTL8168D/8111D, and RTL8168DP/8111DP
Gigabit Ethernet controllers with PCI-Express interface.

%prep
rm -rf kernel-source-%module_name-%module_version
tar -jxvf %kernel_src/kernel-source-%module_name-%module_version.tar.bz2
%setup -D -T -n kernel-source-%module_name-%module_version

%build
. %_usrsrc/linux-%kversion-%flavour/gcc_version.inc
%make_build KERNELDIR=%_usrsrc/linux-%kversion-%flavour modules

%install
install -Dp -m600 src/%module_name.ko %buildroot/%module_dir/%module_name.ko

%files
%module_dir/%module_name.ko

%changelog
