Name:    keycloak
Version: 26.4.0
Release: alt1

Summary: Open Source Identity and Access Management For Modern Applications and Services
License: Apache-2.0
Group:   System/Servers
Url:     https://github.com/keycloak/keycloak

Packager: Andrey Cherepanov <cas@altlinux.org>

ExclusiveArch: x86_64

Source: %name-%version.tar
Source1: kc.sh
Source2: m2.tar
Source3: node.tar
Source4: keycloak.service
Patch0: keycloak-alt-remove-javaPathHelper.patch
Patch1: keycloak-alt-pathes.patch
Patch2: keycloak-alt-ssl-certificates.patch
Patch3: 0001-Exclude-base-theme-from-settings.patch

BuildRequires(pre): /proc rpm-build-java
BuildRequires: jpackage-17-compat
BuildRequires: maven-local

Requires: java >= 17.0.0

AutoReqProv: yes, noosgi-fc

%description
Keycloak provides user federation, strong authentication, user management,
fine-grained authorization, and more.

%prep
%setup
%autopatch -p1
test -d ~/.m2 && rm -rf ~/.m2
test -d js/node_modules && rm -rf js/{node,node_modules}
tar xf %SOURCE2 -C ~
tar xf %SOURCE3
%pom_disable_module test-framework
%pom_disable_module tests

%build
#mvn -pl quarkus/deployment,quarkus/dist -am -DskipTests clean install
pushd quarkus
mvn -f ../pom.xml clean install -am -DskipTestsuite -DskipExamples -DskipTests -DskipProtoLock=true
popd

%install
mkdir -p %buildroot%_libexecdir/%name
tar xf quarkus/dist/target/%name-%version.tar.gz --strip=1 -C %buildroot%_libexecdir/%name
mkdir -p %buildroot%_sysconfdir
mv %buildroot%_libexecdir/%name/conf %buildroot%_sysconfdir/%name
install -Dpm 0755 %SOURCE1 %buildroot%_bindir/kc.sh
install -Dpm 0644 %SOURCE4 %buildroot%_unitdir/keycloak.service

%preun
%preun_service keycloak

%post
test -f /usr/share/keycloak/conf/keycloak.conf && cp -f /usr/share/keycloak/conf/keycloak.conf /etc/keycloak/keycloak.conf
/usr/bin/kc.sh build &>/dev/null ||:
%post_service keycloak

%files
%doc README.md
%config(noreplace) %_sysconfdir/%name/%name.conf
%config(noreplace) %_sysconfdir/%name/cache-ispn.xml
%config(noreplace) %_unitdir/keycloak.service
%_bindir/kc.sh
%dir %_sysconfdir/%name
%doc %_sysconfdir/%name/README.md
%dir %_sysconfdir/%name/truststores
%_libexecdir/%name

%changelog
