Epoch: 1
Group: Security/Networking
# BEGIN SourceDeps(oneline):
BuildRequires: /usr/bin/protoc /usr/bin/protoc-c binutils-devel libdw-devel libsensors3-devel libunwind-devel zlib-devel
# END SourceDeps(oneline)
# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}
# %%name is ahead of its definition. Predefining for rpm 4.0 compatibility.
%define name kismet
%global _version        2020-09-R4

## {Local macros...
%global cfgdir          %_sysconfdir/%name
%global _rpmversion     0.0.%(echo %_version | tr - .)
## ...local macros}

%{!?apply:%global  apply(p:n:b:) %patch%%{-n:%%{-n*}} %%{-p:-p%%{-p*}} %%{-b:-b%%{-b*}} \
%nil}

Summary:        WLAN detector, sniffer and IDS
Name:           kismet
Version:        %_rpmversion
Release:        alt1_2
License:        GPLv2+
URL:            http://www.kismetwireless.net/
Source0:        http://www.kismetwireless.net/code/%{name}-%_version.tar.xz

Patch0:         kismet-include.patch
Patch1:         kismet-install.patch

BuildRequires:  gcc
BuildRequires:  gcc-c++
BuildRequires:  libncurses++-devel libncurses-devel libncursesw-devel libtic-devel libtinfo-devel diffutils
BuildRequires:  libpcap-devel libpcre-devel libpcrecpp-devel
BuildRequires:  libssl-devel libcap-devel libnl-devel
BuildRequires:  libbluez-devel
BuildRequires:  libmicrohttpd-devel libprotobuf-devel libprotobuf-c-devel
BuildRequires:  libnm-devel libnm-gir-devel libusb-devel
BuildRequires:  libsqlite3-devel
Source44: import.info

%description
Kismet is an 802.11 layer2 wireless network detector, sniffer, and
intrusion detection system. Kismet will work with any wireless card
which supports raw monitoring (rfmon) mode, and can sniff 802.11b,
802.11a, and 802.11g traffic.

Kismet identifies networks by passively collecting packets and detecting
standard named networks, detecting (and given time, decloaking) hidden
networks, and infering the presence of nonbeaconing networks via data
traffic.

%prep
%setup -qn %{name}-%{_version}

%patch0 -p0
%patch1 -p0

sed -i 's!\$(prefix)/lib/!%{_libdir}/!g' plugin-*/Makefile


# set our 'kismet' user, disable GPS and log into %%logdir by
# default
sed -i \
    -e '\!^ouifile=/etc/manuf!d' \
    -e '\!^ouifile=/usr/share/wireshark/wireshark/manuf!d' \
    conf/kismet.conf

%build

export ac_cv_lib_uClibcpp_main=no # we do not want to build against uClibc++, even when available
export LDFLAGS='-Wl,--as-needed'
%configure \
           --sysconfdir=%cfgdir \
           CXXFLAGS="$RPM_OPT_FLAGS -D__STDC_FORMAT_MACROS" \
           --disable-python-tools

%make_build

sed -i s/2019-08-GIT/%{version}-%{release}%{?dist}/g packaging/kismet.pc

%install
BIN=$RPM_BUILD_ROOT/bin ETC=$RPM_BUILD_ROOT/etc %makeinstall_std

%files
%doc CHANGELOG README* docs/
%dir %attr(0755,root,root) %cfgdir
%config(noreplace) %cfgdir/*
%{_bindir}/kismet*
%{_datadir}/kismet
%{_libdir}/pkgconfig/kismet.pc

%changelog
