Name: 	  laptop-mode-tools
Version:  1.74
Release:  alt3

Summary:  Tools for power savings based on battery/AC status
License:  GPL-2.0+
Group:    System/Base
URL:      http://rickysarraf.github.io/laptop-mode-tools/
Packager: Andrey Cherepanov <cas@altlinux.org>

Source:   %name-%version.tar
# VCS:    https://github.com/rickysarraf/laptop-mode-tools
Patch1:   support-condrestart-in-initscript.patch
Patch2:   no-autoreq-systemd.patch

BuildArch: noarch

BuildRequires(pre): rpm-build-python3

%filter_from_requires \,^/lib/udev/hotplug\.functions,d
%add_python3_path %_datadir/%name

%description
Laptop mode is a Linux kernel feature that allows your laptop to save
considerable power, by allowing the hard drive to spin down for longer
periods of time. This package contains the userland scripts that are
needed to enable laptop mode. It includes support for automatically
enabling laptop mode when the computer is working on batteries. In
addition, it provides a set of modules which allow you to apply
various other power savings.

%prep
%setup -q
%patch1 -p1
%patch2 -p1

%build
DESTDIR=%buildroot INIT_D=%buildroot%_initdir MAN_D=%_mandir INSTALL=install TMPFILES_D=%_tmpfilesdir ./install.sh

%preun
%preun_service laptop-mode

%post
%post_service laptop-mode

%files
%doc COPYING Documentation/*.txt README.md
%_sbindir/*
%config %_sysconfdir/acpi/actions/lm_*.sh
%config %_sysconfdir/acpi/events/lm_*
%config(noreplace) %_sysconfdir/laptop-mode/
%config %_initdir/laptop-mode
%_unitdir/*.service
%_unitdir/*.timer
/lib/udev/lmt-udev
/lib/udev/rules.d/99-laptop-mode.rules
%_sysconfdir/apm/event.d/*
%_sysconfdir/power/scripts.d/*
%_sysconfdir/power/event.d/*
%_datadir/laptop-mode-tools
%_libexecdir/pm-utils/sleep.d/*
%_tmpfilesdir/laptop-mode.conf
%_datadir/polkit-1/actions/org.linux.lmt.gui.policy
%_man8dir/*
%_desktopdir/%name.desktop
%_pixmapsdir/%name.svg

%changelog
