%def_with doc
%def_without python

Name: libalsa
Version: 1.2.8
Release: alt1
Epoch: 1

Summary: Advanced Linux Sound Architecture (ALSA) library
License: LGPLv2.1
Group: System/Libraries

Source: %name-%version.tar
Patch0: %name-%version-%release.patch
Patch1: 0001-Restore-loading-usr-share-alsa-alsa.conf.d.patch
Url: http://www.alsa-project.org

# tse3 still depends on that, argh
Provides: libalsa2 = %version
Obsoletes: libalsa2 < %version

# for fourth-party software
Provides: alsa-lib = %version

# factored out from alsa-lib.git
Requires: alsa-ucm-conf
Requires: alsa-topology-conf

# Automatically added by buildreq on Mon Dec 26 2016
# optimized out: perl python-base python-modules
%{?_with_doc:BuildRequires: doxygen}

# for smixer plugins, see commit a668a94238dc67b19ae187b52a161e027d79ee5d
%{?_with_python:BuildRequires: python-dev}

%define pkgdocdir %_docdir/%name-%version
%define modutils_oss /etc/modutils.d/oss
%define modules_conf /etc/modules.conf
%define modprobe_old %_sysconfdir/modprobe.d/alsa-modindex
%define modprobe_conf %modprobe_old.conf

%define _unpackaged_files_terminate_build 1
%define _stripped_files_terminate_build 1
%set_verify_elf_method strict

%{?optflags_lto:%global optflags_lto %optflags_lto -flto-partition=none}

%description
Advanced Linux Sound Architecture (ALSA) libs. Modularized
architecture with support for a large range of ISA and PCI cards.
Fully compatible with OSS/Lite (kernel sound drivers), but
contains many enhanced features.

%package -n aserver
Summary: Sound server for alsa
Group: Sound
Requires: %name = %epoch:%version-%release

%description -n aserver
Sound server for ALSA

%package devel
Summary: Development environment for Advanced Linux Sound Architecture (ALSA)
Group: Development/C
Requires: %name = %epoch:%version-%release
Provides: libalsa2-devel = %version
Obsoletes: libalsa2-devel < %version

%description devel
Advanced Linux Sound Architecture (ALSA) libs. Modularized
architecture with support for a large range of ISA and PCI cards.
Fully compatible with OSS/Lite (kernel sound drivers), but
contains many enhanced features.

This is the development environment to compile ALSA applications.

%if_with doc
%package docs
Summary: Documentation for Advanced Linux Sound Architecture (ALSA)
Group: Development/Documentation
BuildArch: noarch

%description docs
Advanced Linux Sound Architecture (ALSA) Developer Documentation
(C library reference)
%endif

%prep
%setup
%patch0 -p1
%patch1 -p1
# Replace "include" with "__include__" in public header files
# to make them compilable by "gcc -ansi" again.
find include -type f -print0 |
	xargs -r0 grep -FZl ' inline ' -- |
	xargs -r0 sed -i 's/ inline / __inline__ /g' --

%build
%add_optflags -D_FILE_OFFSET_BITS=64

%ifnarch %e2k
# http://github.com/alsa-project/alsa-lib/issues/6
# http://gcc.gnu.org/bugzilla/show_bug.cgi?id=48200
%add_optflags -flto -flto-partition=none
%endif

%autoreconf
%configure \
	--with-configdir=%_datadir/alsa \
	%{?!_with_python:--disable-python} \
	--disable-static
%make_build
%{?_with_doc:%make doc}

%install
%makeinstall_std

find %buildroot%_libdir -name \*.la -delete

install -pDm644 asound.conf.sonicvibes_2 %buildroot%_datadir/alsa/cards/SonicVibes.conf

mkdir -p %buildroot%pkgdocdir
%if_with doc
install -pm644 NOTES MEMORY-LEAK TODO %buildroot%pkgdocdir/
cp -a doc/doxygen/html %buildroot%pkgdocdir/
%endif

mkdir -p %buildroot%_sysconfdir/modprobe.d
cat << __EOF__ >> %buildroot%modprobe_conf
## spare index=0 for a hotplug soundcard (if any)
#options snd-usb-audio index=0

## offset HDMI output compared to onboard audio (#28648)
#options snd_hda_codec_hdmi index=2,3
#options snd_hda_intel index=2,3

#options snd_intel8x0 index=2
#options snd_via82xx index=2
#options snd-bt87x index=3
#options snd_intel8x0m index=4
#options snd-atiixp-modem index=4
#options snd-via82xx-modem index=4

## get PC speaker out of the way
options snd_pcsp index=10
__EOF__

install -d %buildroot%_localstatedir/alsa

%pre
[ ! -f %modutils_oss ] || {
	grep -q "^above snd-" %modules_conf && {
		echo '*** %modutils_oss found:'
		echo '*** commenting out "above/below snd-*-oss" lines in %modules_conf'
		subst 's/^above snd-.* snd-.*-oss$/#&/' %modules_conf ||:
	} ||:
}

%post
# newer module-init-tools barf at files missing .conf suffix
# (and rightfully so)
rm -f %modprobe_old~
for suffix in "" .rpmnew .rpmsave; do
	[ -f "%modprobe_old$suffix" ] && {
		echo '*** migrating configuration, please check:'
		mv -v "%modprobe_conf" "%modprobe_old.rpmorig"
		mv -v "%modprobe_old$suffix" "%modprobe_conf"
		exit 0
	} ||:
done

%files
%_libdir/*.so.*
%if_with python
%dir %_libdir/alsa-lib
%_libdir/alsa-lib/smixer
%endif
%config(noreplace) %modprobe_conf
%_datadir/alsa
%dir %_localstatedir/alsa

%files devel
%_includedir/sys/*
%_includedir/alsa
%_includedir/asoundlib.h
%_libdir/*.so
%_pkgconfigdir/alsa.pc
%_pkgconfigdir/alsa-topology.pc
%_datadir/aclocal/*

%if_with doc
%files docs
%dir %pkgdocdir
%pkgdocdir/[D-Z]*
%pkgdocdir/html
%endif

%files -n aserver
%_bindir/aserver

%changelog
