%def_enable pcsc
%def_disable static
%def_enable test

Name: libcacard
Version: 2.8.0
Release: alt1
Summary: Common Access Card (CAC) Emulation
Group: System/Libraries
License: LGPLv2.1+
Url: http://www.spice-space.org/download
# https://gitlab.freedesktop.org/spice/libcacard.git
Source: %name-%version.tar
Patch1: libcacard-2.8.0-32bit.patch

BuildRequires(pre): meson
BuildRequires: gcc-c++
BuildRequires: pkgconfig(glib-2.0) >= 2.32
BuildRequires: pkgconfig(nss) >= 3.12.8
%{?_enable_pcsc:BuildRequires: pkgconfig(libpcsclite)}
%{?_enable_test:BuildRequires: openssl gnutls-utils nss-utils opensc softhsm}

%description
Common Access Card (CAC) emulation library.

%package devel
Summary: CAC Emulation devel
Group: Development/C
Requires: %name = %version-%release

%description devel
CAC emulation development files.

%prep
%setup
%patch1 -p1
echo "%version" > .tarball-version

%build
%meson \
	%{?_enable_pcsc:-Dpcsc=enabled} \
	%{?_disable_test:-Ddisable_tests=true}

%meson_build

%install
%meson_install

%check
%meson_test

%files
%doc COPYING README.md NEWS
%_libdir/libcacard.so.*

%files devel
%_includedir/cacard
%_pkgconfigdir/*.pc
%_libdir/libcacard.so

%changelog
