%def_without docs

Name: libcairo
Version: 1.16.0
Release: alt2
Epoch: 1
Summary: Multi-platform 2D graphics library
License: LGPL
Group: System/Libraries
URL: http://cairographics.org/

Source: cairo-%version.tar
Patch: cairo-%version-%release.patch

BuildRequires: fontconfig-devel ghostscript-classic glib2-devel gtk-doc libGL-devel libXrender-devel
BuildRequires: libfreetype-devel libpixman-devel libpng-devel librsvg-devel libudev-devel zlib-devel
BuildRequires: libEGL-devel libGLES-devel libXext-devel

%description
Cairo is a vector graphics library with cross-device output support

%package devel
Summary: Headers for developing programs that will use cairo
Group: Development/C
Requires: %name = %epoch:%version-%release

%description devel
Cairo is a vector graphics library with cross-device output support.
This package contains the headers that programmers will need to develop
applications which will use cairo library.

%package gobject
Summary: GObject bindings for cairo
Group: System/Libraries
Requires: %name = %epoch:%version-%release

%description gobject
This package contains functionality to make cairo graphics library
integrate well with the GObject object system used by GNOME.

%package gobject-devel
Summary: Development files for cairo-gobject
Group: Development/C
Requires: %name-gobject = %epoch:%version-%release
Requires: %name-devel = %epoch:%version-%release

%description gobject-devel
This package contains libraries, header files and developer documentation
needed for developing software which uses the cairo Gobject library.

%package tools
Summary: Development tools for cairo
Group: Development/C

%description tools
This package contains tools for working with the cairo graphics library.
 * cairo-trace: Record cairo library calls for later playback

%prep
%setup -q -n cairo-%version
%patch -p1

%build
%autoreconf
%configure \
	--enable-xlib \
	--enable-xcb \
	--enable-ps \
	--enable-pdf \
	--enable-svg \
	--enable-tee \
	--disable-xml \
	--disable-silent-rules \
%if_with docs
	--enable-gtk-doc \
%endif
	--disable-static \
	--localstatedir=%_var
%make_build
%if_with docs
%make doc
%endif

%install
%make DESTDIR=%buildroot install

#%check
#%make -k test

%files
%doc AUTHORS NEWS README
%_libdir/%name.so.*
%_libdir/%name-script-interpreter.so.*
%_bindir/cairo-sphinx

%files devel
%_includedir/cairo
%exclude %_includedir/cairo/cairo-gobject.h
%_libdir/%name.so
%_libdir/%name-script-interpreter.so
%_pkgconfigdir/*.pc
%exclude %_pkgconfigdir/cairo-gobject.pc
%if_with docs
%_datadir/gtk-doc/html/cairo
%endif

%files gobject
%_libdir/%name-gobject.so.*

%files gobject-devel
%_includedir/cairo/cairo-gobject.h
%_libdir/%name-gobject.so
%_pkgconfigdir/cairo-gobject.pc

%files tools
%_bindir/cairo-trace
%_libdir/cairo

%changelog
