Name: libcap-ng
Version: 0.8.2
Release: alt1

Summary: An alternate posix capabilities library
License: LGPLv2+
Group: System/Libraries

Url: http://people.redhat.com/sgrubb/libcap-ng
Source: %name-%version.tar

BuildRequires: kernel-headers
BuildRequires: libattr-devel

# not BR(pre) as we don't need those macros to rpm -bs
# (only used within setup/build/install/files sections);
# see also https://bugzilla.altlinux.org/8579
BuildPreReq: rpm-build-python3
BuildPreReq: python3-devel
BuildRequires: swig

%description
Libcap-ng is a library that makes using posix capabilities easier

%package devel
Summary: Header files for libcap-ng library
License: LGPLv2+
Group: Development/C
Requires: kernel-headers >= 2.6.11
Requires: %name = %EVR

%description devel
The libcap-ng-devel package contains the files needed for developing
applications that need to use the libcap-ng library.

%package -n python3-module-%name
Summary: Python bindings for libcap-ng library
License: LGPLv2+
Group: Development/Python3
Requires: %name = %EVR

%description -n python3-module-%name
The libcap-ng-python package contains the bindings so that libcap-ng
and can be used by python applications.

%package utils
Summary: Utilities for analysing and setting file capabilities
License: GPLv2+
Group: Development/C

%description utils
The libcap-ng-utils package contains applications to analyse the
posix capabilities of all the program running on a system. It also
lets you set the file system based capabilities.

%prep
%setup

%build
%autoreconf
export PYTHON=python3
%configure --libdir=/%_lib
%make_build PYLIBVER=python%_python3_version%_python3_abiflags


%install
%makeinstall_std

# Move the symlink
rm -f %buildroot/%_lib/%name.so
rm -f %buildroot/%_lib/libdrop_ambient.so
mkdir -p %buildroot%_libdir
VLIBNAME=$(ls %buildroot/%_lib/%name.so.*.*.*)
VLIBNAME_DROP=$(ls %buildroot/%_lib/libdrop_ambient.so.*.*.*)
LIBNAME=$(basename $VLIBNAME)
LIBDROP_NAME=$(basename $VLIBNAME_DROP)
ln -s ../../%_lib/$LIBNAME %buildroot%_libdir/%name.so
ln -s ../../%_lib/$LIBDROP_NAME %buildroot%_libdir/libdrop_ambient.so

# Move the pkgconfig file
mv %buildroot/%_lib/pkgconfig %buildroot%_libdir

# Remove a couple things so they don't get picked up
rm -f %buildroot/%_lib/*.{a,la}
rm -f %buildroot%python3_sitelibdir/*.{a,la}

%files
%doc COPYING.LIB
/%_lib/libcap-ng.so.*
/%_lib/libdrop_ambient.so.*

%files devel
%_man3dir/*
%_includedir/cap-ng.h
%_libdir/libcap-ng.so
%_libdir/libdrop_ambient.so
%_datadir/aclocal/cap-ng.m4
%_pkgconfigdir/libcap-ng.pc

%files utils
%doc COPYING
%_bindir/*
%_man8dir/*
%_man7dir/*

%files -n python3-module-%name
%python3_sitelibdir/*

%changelog
