%define _name exo

Name: lib%_name
Version: 4.18.0
Release: alt1

Summary: Extension library to Xfce
Summary (ru_RU.UTF-8): Библиотека расширений Xfce
License: LGPLv2+ and GPLv2+
Group: System/Libraries
Url: https://docs.xfce.org/xfce/exo/start
Packager: Xfce Team <xfce@packages.altlinux.org>

Vcs: https://gitlab.xfce.org/xfce/exo.git
Source: %_name-%version.tar
Patch: %_name-%version-%release.patch

BuildRequires: rpm-build-xfce4  xfce4-dev-tools >= 4.15 libxfce4util-devel >= 4.17.2
BuildRequires: libgtk+3-devel libxfce4ui-gtk3-devel
BuildRequires: glib2-devel >= 2.66
BuildRequires: gtk-doc intltool

Requires: %name-common = %version-%release
# There is no longer python bindings for exo.
Conflicts: python-module-exo < 0.7.0

%define _unpackaged_files_terminate_build 1

%description
Libexo is an Xfce library targeted at application development. It contains
various custom widgets and APIs extending the functionality of GLib and
GTK. It also ships utilities for defining preferred applications,
mounting storage devices and more.

%description -l ru_RU.UTF-8
Libexo - библиотека расширений Xfce предназначенная для использования в
приложениях разрабатываемых под Xfce.

%package common
Summary: Common files for %name
Group: Graphical desktop/XFce
Requires: xfce4-common
BuildArch: noarch

%description common
Common files used by all %name variants.

%package -n %_name-utils
Summary: Utility files for %name
Group: Graphical desktop/XFce

%description -n %_name-utils
This package conteins Xfce utilities for defining preferred applications,
mounting storage devices and more.

%package gtk3
Summary: Extension library to Xfce (GTK+3 version)
Group: System/Libraries
Requires: %name-common = %version-%release

%description gtk3
Libexo is an Xfce library targeted at application development. It contains
various custom widgets and APIs extending the functionality of GLib and GTK.
This is a GTK+3 version.

%package gtk3-devel
Summary: Development files for %name-gtk3
Group: Development/C
Requires: %name-gtk3 = %version-%release

%description gtk3-devel
This package contains development files required for packaging
%name-based software.
This is a GTK+3 version.

%package devel-doc
Summary: Documentation files for %name
Group: Development/Documentation
BuildArch: noarch
Conflicts: %name-gtk3-devel < %version-%release

%description devel-doc
This package contains documentation files required for packaging
%name-based software.

%prep
%setup -n %_name-%version
%patch -p1

# Don't use git tag in version.
%xfce4_drop_gitvtag libexo_version_tag configure.ac.in

%build
%xfce4reconf
%configure \
	--disable-static \
	--enable-maintainer-mode \
	--enable-gtk-doc \
	--enable-debug=minimum

# Seems there is race in desktop files processing
export NPROCS=1
%make_build

%install
%makeinstall_std
%find_lang %_name

%check
make check

%files common -f %_name.lang
%doc AUTHORS NEWS README.md
%_pixmapsdir/%_name/

%files -n %_name-utils
%_bindir/*
%_man1dir/*

%files gtk3
%_libdir/%name-2.so.*

%files gtk3-devel
%_includedir/%_name-2/
%_libdir/%name-2.so
%_pkgconfigdir/%_name-2.pc

%files devel-doc
%_datadir/gtk-doc/html/%{_name}*

%changelog
