%def_enable ssh
%def_disable cli
%def_enable check

Name: libgit2
Version: 1.7.2
Release: alt1

Summary: linkable library for Git
License: GPL-2.0

Group: System/Libraries
Url: https://github.com/%name

Vcs: https://github.com/libgit2/libgit2.git
Source: %url/%name/archive/v%version/%name-%version.tar.gz

BuildRequires(pre): rpm-macros-cmake
BuildRequires: cmake ninja-build python3
BuildRequires: zlib-devel libpcre2-devel libssl-devel
%{?_enable_ssh:BuildRequires: libssh2-devel}
BuildRequires: libkrb5-devel libhttp-parser-devel
%{?_enable_check:BuildRequires: ctest}

%description
A cross-platform, linkable library implementation of Git that you can use
in your applications.

%package devel
Group: Development/C
Summary: linkable library for Git - development files
Requires: %name = %EVR

%description devel
A cross-platform, linkable library implementation of Git that you can use
in your applications.

This package contains %name development files.

%prep
%setup
rm -rf deps/{pcre,zlib,http-parser}
sed -i 's/LIB_INSTALL_DIR lib/LIB_INSTALL_DIR lib${LIB_SUFFIX}/' CMakeLists.txt

# Disable online tests
sed -i '/-sonline/s/^/#/' tests/libgit2/CMakeLists.txt

%build
%add_optflags %(getconf LFS_CFLAGS)
%cmake -G Ninja \
   -DBUILD_TYPE=Release \
   -DTHREADSAFE:BOOL=ON \
   -DUSE_SHA1DC:BOOL=ON \
   -DREGEX_BACKEND=pcre2 \
   -DUSE_HTTP_PARSER=system \
   -DENABLE_REPRODUCIBLE_BUILDS=ON \
   -DDEPRECATE_HARD=OFF \
   -DUSE_NTLMCLIENT=OFF \
   %{?_disable_cli:-DBUILD_CLI=OFF} \
   %{?_enable_ssh:-DUSE_SSH=ON}
%nil
%cmake_build

%install
%cmake_install

%check
%cmake_build -t test

%files
%{?_enable_cli:%_bindir/git2}
%_libdir/%name.so.*
%doc README.md AUTHORS COPYING

%files devel
%_includedir/git2
# exclude headers for windows
%exclude %_includedir/git2/stdint.h
%_includedir/git2.h
%_libdir/%name.so
%_pkgconfigdir/%name.pc

%changelog
