Name: libgksu
Version: 2.0.12
Release: alt10

Summary: A 'su' and 'sudo' wrapper library for GTK+/GNOME applications
License: %lgpl2plus
Group: System/Libraries
Url: http://www.nongnu.org/gksu/
Source: http://people.debian.org/~kov/gksu/%name-%version.tar.gz
Source1: libgksu-l10n.tar
Patch1: %name-2.0.12-fix-desktop-file.patch
Patch2: %name-2.0.12-helperdir.patch
Patch3: %name-only-glib.h-includes.patch
Patch4: %name-2.0.12-alt-DSO.patch
Patch5: %name-2.0.12-alt-make-3.82.patch
Patch6: %name-2.0.12-alt-drop-n.patch

Requires(preun,post): GConf

BuildPreReq: rpm-build-licenses rpm-build-gnome

# From configure.ac
BuildPreReq: libgtk+2-devel >= 2.12.0
BuildPreReq: GConf2 libGConf2-devel libstartup-notification-devel libgnome-keyring-devel libgtop2-devel intltool
BuildPreReq: gettext-tools
BuildPreReq: gtk-doc >= 1.0

BuildRequires: perl-XML-Parser

%description
GKSu is a stack of libraries and an application that provide a Gtk+
frontend to su and sudo. It supports login shells and preserving
environment when acting as a su frontend. It is useful to menu items or
other graphical programs that need to ask a user's password to run
another program as another user.

This package contains the authentication library. To use the
application, install gksu package.

%package devel
Summary: Development files for libgksu
Group: Development/GNOME and GTK+
Requires: %name = %version-%release

%description devel
GKSu is a stack of libraries and an application that provide a Gtk+
frontend to su and sudo. It supports login shells and preserving
environment when acting as a su frontend. It is useful to menu items or
other graphical programs that need to ask a user's password to run
another program as another user.

This package contains the files necessary for development/compilation of
programs that use %name.

%define libname libgksu2

%prep
%setup -q
%patch1
%patch2
%patch3 -p2
%patch4 -p2
%patch5 -p2
%patch6 -p1
tar xf %SOURCE1

%build
touch README NEWS
%autoreconf
%configure \
    --disable-static \
    --disable-gtk-doc

%make_build

%install
%make_install install DESTDIR=%buildroot
install -pDt %buildroot%_datadir/gtk-doc/html/%name docs/html/*

# Fix icons location
mkdir -p %buildroot%_liconsdir
cp -a %buildroot%_pixmapsdir/gksu.png %buildroot%_liconsdir

%find_lang %name

%post
%gconf2_install gksu

%preun
if [ $1 = 0 ]; then
%gconf2_uninstall gksu
fi

%files -f %name.lang
%_libdir/%libname.so.*
%dir %_libexecdir/%name
%_libexecdir/%name/gksu-run-helper
%_bindir/gksu-properties
%dir %_datadir/%name
%_datadir/%name/gksu-properties.ui
%_pixmapsdir/gksu.png
%_liconsdir/gksu.png
%_desktopdir/gksu-properties.desktop
%_man1dir/gksu-properties.1*
%config %gconf_schemasdir/gksu.schemas

%files devel
%dir %_includedir/%name
%_includedir/%name/*.h
%_libdir/%libname.so
%_pkgconfigdir/%libname.pc
%dir %_datadir/gtk-doc/html/%name
%_datadir/gtk-doc/html/%name/*

%changelog
