Name: libgpg-error
Version: 1.42
Release: alt1

Group: System/Libraries
Summary: Error library for GnuPG and related projects
License: GPL-2.0-or-later AND LGPL-2.1-or-later
URL: https://www.gnupg.org/

%define _unpackaged_files_terminate_build 1
%define _stripped_files_terminate_build 1

%set_verify_elf_method strict

Source: %name-%version.tar

Patch0: libgpg-error-1.29-multilib.patch
Patch1: 0001-Fix-LFS-on-32-bit-systems.patch
Patch2: 0002-ALT-version-is-not-beta.patch

BuildRequires: makeinfo

%package devel
Summary: Development files for the %name package
License: GPL-2.0-or-later AND LGPL-2.1-or-later AND MIT
Group: Development/C
Requires: %name = %version-%release

%description
This is a library that defines common error values for all GnuPG
components.  Among these are GPG, GPGSM, GPGME, GPG-Agent, libgcrypt,
pinentry, SmartCard Daemon and possibly more in the future.

%description devel
This package contains files needed to develop
applications using the GnuPG error library.

%prep
%setup -q
%autopatch -p1

cat > doc/version.texi <<EOF
@set UPDATED $(LANG=C date -u -r doc/gpgrt.texi +'%%d %%B %%Y')
@set UPDATED-MONTH $(LANG=C date -u -r doc/gpgrt.texi +'%%B %%Y')
@set EDITION %version
@set VERSION %version
EOF

%build
%autoreconf
%configure \
	--disable-static \
	--with-pic
%make_build

%install
%makeinstall_std

# relocate shared libraries from %_libdir/ to /%_lib/.
mkdir -p %buildroot/%_lib
for f in %buildroot%_libdir/libgpg-error.so; do
        t=$(readlink -v "$f")
        ln -rsnf %buildroot/%_lib/"$t" "$f"
done
mv %buildroot%_libdir/*.so.* %buildroot/%_lib/

%find_lang %name

%check
%make check

%files -f %name.lang
/%_lib/lib*.so.*
%_bindir/gpg-error
%_datadir/libgpg-error/
%doc AUTHORS NEWS README

%files devel
%_bindir/*-config
%_bindir/yat2m
%_libdir/*.so
%_includedir/*
%_aclocaldir/*
%_man1dir/gpgrt-config.1.*
%_infodir/gpgrt.*
%_pkgconfigdir/*.pc
%_datadir/common-lisp/source/gpg-error

%changelog
