%def_disable snapshot
%def_enable installed_tests
%{?_enable_snapshot:%def_enable gtk_doc}
%def_enable check

%define _name gspell
%define ver_major 1.12
%define api_ver 1

Name: lib%_name
Version: %ver_major.1
Release: alt1

Summary: A spell-checking library for GTK+ applications
Group: System/Libraries
License: LGPLv2.1+
Url: https://wiki.gnome.org/Projects/gspell

%if_disabled snapshot
Source: ftp://ftp.gnome.org/pub/gnome/sources/%_name/%ver_major/%_name-%version.tar.xz
%else
Source: %_name-%version.tar
%endif

%define gtk_ver 3.20.0
%define enchant_ver 2.2.12

BuildRequires(pre): rpm-build-gir rpm-build-vala
BuildRequires: autoconf-archive
BuildRequires: libgtk+3-devel >= %gtk_ver libenchant2-devel >= %enchant_ver libicu-devel
BuildRequires: gobject-introspection-devel libgtk+3-gir-devel vala-tools gtk-doc
%{?_enable_check:BuildRequires: xvfb-run hunspell-en valgrind}

%description
gspell library provides a flexible API to add spell checking to a GTK+
applications.

%package devel
Summary: Development files for %name
Group: Development/C++
Requires: %name = %version-%release
Requires: libenchant2-devel >= %enchant_ver

%description devel
Development files for %_name, spell-checking library for GTK+
applications.

%package gir
Summary: GObject introspection data for the Gspell
Group: System/Libraries
Requires: %name = %version-%release

%description gir
GObject introspection data for the Gspell library.

%package gir-devel
Summary: GObject introspection devel data for the Gspell
Group: Development/Other
BuildArch: noarch
Requires: %name-gir = %version-%release
Requires: %name-devel = %version-%release

%description gir-devel
GObject introspection devel data for the Gspell library.

%package devel-doc
Summary: Development documentation for Gspell
Group: Development/Documentation
Conflicts: %name < %version-%release
BuildArch: noarch

%description devel-doc
This package contains development documentation for Gspell library.

%package tests
Summary: Tests for Gspell library
Group: Development/Other
Requires: %name = %version-%release

%description tests
This package provides tests programs that can be used to verify
the functionality of the installed Gspell library.


%prep
%setup -n %_name-%version

%build
%autoreconf
%configure \
    %{?_enable_gtk_doc:--enable-gtk-doc} \
    %{?_enable_installed_tests:--enable-installed-tests}

%install
%makeinstall_std
%find_lang --output=%name.lang %_name-%api_ver

%check
xvfb-run %make -k check VERBOSE=1

%files -f %name.lang
%_bindir/%_name-app1
%_libdir/%name-%api_ver.so.*
%doc AUTHORS NEWS README

%files devel
%_includedir/%_name-%api_ver/
%_libdir/%name-%api_ver.so
%_pkgconfigdir/%_name-%api_ver.pc
%_vapidir/%_name-%api_ver.*

%files gir
%_typelibdir/Gspell-%api_ver.typelib

%files gir-devel
%_girdir/Gspell-%api_ver.gir

%files devel-doc
%_datadir/gtk-doc/html/%_name-*/

%if_enabled installed_tests
%files tests
%_libexecdir/installed-tests/%_name-%api_ver/
%_datadir/installed-tests/%_name-%api_ver/
%endif


%changelog
