%define _unpackaged_files_terminate_build 1

%define oname hdf5
%define sover 103
%define soverhl 100

Name: lib%oname
Version: 1.10.6
Release: alt2

Summary: Hierarchical Data Format 5 library
License: Nearly BSD, but changed sources must be marked
Group: System/Libraries

Url: http://www.hdfgroup.org/HDF5/
# https://github.com/HDFGroup/hdf5.git
Source: %name-%version.tar
Patch: %name-alt-disable-rpath.patch

# Automatically added by buildreq on Sat Sep 15 2007
BuildRequires: gcc-c++ libssl-devel zlib-devel

%description
HDF5 is a completely new Hierarchical Data Format product consisting
of a data format specification and a supporting library
implementation. HDF5 is designed to address some of the limitations of
the older HDF product and to address current and anticipated
requirements of modern systems and applications.

%package -n lib%oname-%sover
Summary: Hierarchical Data Format 5 library
Group: System/Libraries

%description -n lib%oname-%sover
HDF5 is a completely new Hierarchical Data Format product consisting
of a data format specification and a supporting library
implementation. HDF5 is designed to address some of the limitations of
the older HDF product and to address current and anticipated
requirements of modern systems and applications.

%package -n lib%oname-hl-%soverhl
Summary: Hierarchical Data Format 5 library
Group: System/Libraries
Requires: lib%oname-%sover = %EVR

%description -n lib%oname-hl-%soverhl
HDF5 is a completely new Hierarchical Data Format product consisting
of a data format specification and a supporting library
implementation. HDF5 is designed to address some of the limitations of
the older HDF product and to address current and anticipated
requirements of modern systems and applications.

%package -n lib%oname-devel
Summary: HDF5 library development package
Group: Development/C
Requires: libstdc++-devel zlib-devel
Requires: lib%oname-%sover = %EVR
Requires: lib%oname-hl-%soverhl = %EVR
Conflicts: lib%oname-mpi-devel < 1.8.3-alt5

%description -n lib%oname-devel
Header files for HDF5 library.

%package -n %oname-tools
Summary: HDF5 tools
Group: Development/Tools
Conflicts: %oname-mpi-tools < 1.8.3-alt5

%description -n %oname-tools
HDF5 is a completely new Hierarchical Data Format product consisting
of a data format specification and a supporting library
implementation. HDF5 is designed to address some of the limitations of
the older HDF product and to address current and anticipated
requirements of modern systems and applications.

This package contains tools for work with HDF5.

%package -n %oname-examples
Summary: HDF5 examples
Group: Development/Documentation
BuildArch: noarch

%description -n %oname-examples
HDF5 is a completely new Hierarchical Data Format product consisting
of a data format specification and a supporting library
implementation. HDF5 is designed to address some of the limitations of
the older HDF product and to address current and anticipated
requirements of modern systems and applications.

This package contains examples for HDF5.

%prep
%setup
%patch -p1

%ifarch %e2k
# unsupported by lcc as of 1.21.21
sed -i	-e 's,-Wlogical-op,,' \
	-e 's,-Wvla,,' \
	-e 's,-Wsync-nand,,' \
	-e 's,-Wdouble-promotion,,' \
	-e 's,-Wnull-dereference,,' \
	-e 's,-Whsa,,' \
	-e 's,-Wnormalized,,' \
	-e 's,-Walloc-zero,,' \
	-e 's,-Walloca,,' \
	-e 's,-Wformat-overflow=2,,' \
	-e 's,-Wrestrict,,' \
	CMakeLists.txt config/gnu-flags \
	config/cmake/HDFCompilerFlags.cmake
%endif

%build
%autoreconf
%add_optflags -fno-strict-aliasing
# --with-default-api-version=v18 is needed for libnetcdf
%configure \
	--enable-hl \
	--enable-cxx \
	--enable-shared \
	--disable-static \
	--disable-sharedlib-rpath \
	--enable-build-mode=production \
	--with-pic \
	--with-pthread \
	--with-zlib \
	--with-szlib \
	--with-default-api-version=v18 \
	%nil

%make_build

%install
%makeinstall_std

install -d %buildroot%_pkgconfigdir
cat << EOF > %buildroot%_pkgconfigdir/%oname.pc
prefix=%prefix
exec_prefix=%prefix
libdir=%_libdir
includedir=%_includedir

Name: %oname
Description: Hierarchical Data Format 5 library
Version: %version
Libs: -lhdf5_hl_cpp -lhdf5_hl -lhdf5_cpp -lhdf5 -lstdc++ -lz
EOF

%files -n lib%oname-%sover
%doc COPYING COPYING_LBNL_HDF5
%doc README.txt release_docs/{HISTORY*,RELEASE.txt}
%_libdir/lib*.so.%{sover}
%_libdir/lib*.so.%{sover}.*

%files -n lib%oname-hl-%soverhl
%_libdir/lib*.so.%{soverhl}
%_libdir/lib*.so.%{soverhl}.*

%files -n lib%oname-devel
%_libdir/lib*.so
%_includedir/*
%_pkgconfigdir/*

%files -n %oname-tools
%_bindir/*
# used to show configuration at runtime
%_libdir/libhdf5.settings

%files -n %oname-examples
%_datadir/hdf5_examples

%changelog
